/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.concept.EntityType;
import ai.grakn.concept.Instance;
import ai.grakn.concept.RelationType;
import ai.grakn.concept.ResourceType;
import ai.grakn.concept.Type;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.admin.VarAdmin;
import ai.grakn.graql.internal.pattern.Patterns;
import ai.grakn.graql.internal.pattern.property.DataTypeProperty;
import ai.grakn.graql.internal.pattern.property.IsaProperty;
import ai.grakn.graql.internal.pattern.property.LhsProperty;
import ai.grakn.graql.internal.pattern.property.RhsProperty;
import ai.grakn.graql.internal.pattern.property.SubProperty;
import ai.grakn.graql.internal.pattern.property.ValueProperty;
import ai.grakn.graql.internal.pattern.property.VarPropertyInternal;
import ai.grakn.graql.internal.util.CommonUtil;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class InsertQueryExecutor {
    private final GraknGraph graph;
    private final Collection<VarAdmin> vars;
    private final Map<String, Concept> concepts = new HashMap<String, Concept>();
    private final Stack<String> visitedVars = new Stack();
    private final ImmutableMap<String, List<VarAdmin>> varsByVarName;
    private final ImmutableMap<String, List<VarAdmin>> varsByTypeName;
    private final ImmutableMap<String, List<VarAdmin>> varsById;

    InsertQueryExecutor(Collection<VarAdmin> vars, GraknGraph graph) {
        this.vars = vars;
        this.graph = graph;
        this.varsByVarName = ImmutableMap.copyOf(vars.stream().collect(Collectors.groupingBy(VarAdmin::getVarName)));
        this.varsById = ImmutableMap.copyOf(vars.stream().filter(var -> var.getId().isPresent()).collect(Collectors.groupingBy(var -> (String)var.getId().get())));
        this.varsByTypeName = ImmutableMap.copyOf(vars.stream().filter(var -> var.getTypeName().isPresent()).collect(Collectors.groupingBy(var -> (String)var.getTypeName().get())));
    }

    Stream<Concept> insertAll() {
        return this.insertAll(new HashMap<String, Concept>());
    }

    Stream<Concept> insertAll(Map<String, Concept> results) {
        this.concepts.clear();
        this.concepts.putAll(new HashMap<String, Concept>(results));
        return this.vars.stream().map(this::insertVar);
    }

    private Concept insertVar(VarAdmin var) {
        Concept concept = this.getConcept(var);
        var.getProperties().forEach(property -> ((VarPropertyInternal)property).insert(this, concept));
        return concept;
    }

    public GraknGraph getGraph() {
        return this.graph;
    }

    public Concept getConcept(VarAdmin var) {
        String name = var.getVarName();
        if (this.visitedVars.contains(name)) {
            throw new IllegalStateException(ErrorMessage.INSERT_RECURSIVE.getMessage(new Object[]{var.getPrintableName()}));
        }
        this.visitedVars.push(name);
        Concept concept = this.concepts.computeIfAbsent(name, n -> this.addConcept(var));
        this.visitedVars.pop();
        assert (concept != null) : var;
        return concept;
    }

    private Concept addConcept(VarAdmin varToAdd) {
        VarAdmin var = this.mergeVar(varToAdd);
        Optional type = var.getProperty(IsaProperty.class);
        Optional sub = var.getProperty(SubProperty.class);
        if (type.isPresent() && sub.isPresent()) {
            String printableName = var.getPrintableName();
            throw new IllegalStateException(ErrorMessage.INSERT_ISA_AND_SUB.getMessage(new Object[]{printableName}));
        }
        Optional typeName = var.getTypeName();
        Optional id = var.getId();
        typeName.ifPresent(name -> {
            if (type.isPresent()) {
                throw new IllegalStateException(ErrorMessage.INSERT_INSTANCE_WITH_NAME.getMessage(new Object[]{name}));
            }
        });
        if (sub.isPresent()) {
            return this.putType(typeName, var, (SubProperty)sub.get());
        }
        if (type.isPresent()) {
            return this.putInstance(id, var, (IsaProperty)type.get());
        }
        if (id.isPresent()) {
            Concept concept = this.graph.getConcept((String)id.get());
            if (concept == null) {
                throw new IllegalStateException(ErrorMessage.INSERT_WITHOUT_TYPE.getMessage(new Object[]{id.get()}));
            }
            return concept;
        }
        if (typeName.isPresent()) {
            return this.graph.getType((String)typeName.get());
        }
        throw new IllegalStateException(ErrorMessage.INSERT_UNDEFINED_VARIABLE.getMessage(new Object[]{var.getPrintableName()}));
    }

    private VarAdmin mergeVar(VarAdmin var) {
        boolean changed = true;
        HashSet<VarAdmin> varsToMerge = new HashSet<VarAdmin>();
        while (changed) {
            List vars = (List)this.varsByVarName.getOrDefault((Object)var.getVarName(), (Object)Lists.newArrayList());
            vars.add(var);
            boolean byVarNameChange = varsToMerge.addAll(vars);
            var = Patterns.mergeVars(varsToMerge);
            boolean byIdChange = var.getId().map(id -> varsToMerge.addAll((Collection)this.varsById.get(id))).orElse(false);
            var = Patterns.mergeVars(varsToMerge);
            boolean byTypeNameChange = var.getTypeName().map(id -> varsToMerge.addAll((Collection)this.varsByTypeName.get(id))).orElse(false);
            var = Patterns.mergeVars(varsToMerge);
            changed = byVarNameChange | byIdChange | byTypeNameChange;
        }
        return var;
    }

    private Instance putInstance(Optional<String> id, VarAdmin var, IsaProperty isa) {
        Type type = this.getConcept(isa.getType()).asType();
        if (type.isEntityType()) {
            return this.addOrGetInstance(id, () -> ((EntityType)type.asEntityType()).addEntity());
        }
        if (type.isRelationType()) {
            return this.addOrGetInstance(id, () -> ((RelationType)type.asRelationType()).addRelation());
        }
        if (type.isResourceType()) {
            return this.addOrGetInstance(id, () -> type.asResourceType().putResource(this.getValue(var)));
        }
        if (type.isRuleType()) {
            return this.addOrGetInstance(id, () -> {
                Pattern lhs = ((LhsProperty)var.getProperty(LhsProperty.class).get()).getLhs();
                Pattern rhs = ((RhsProperty)var.getProperty(RhsProperty.class).get()).getRhs();
                return type.asRuleType().addRule(lhs, rhs);
            });
        }
        if (type.getName().equals(Schema.MetaSchema.CONCEPT.getName())) {
            throw new IllegalStateException(var + " cannot be an instance of meta-type " + type.getName());
        }
        throw new RuntimeException("Unrecognized type " + type.getName());
    }

    private Type putType(Optional<String> name, VarAdmin var, SubProperty sub) {
        Type superType = this.getConcept(sub.getSuperType()).asType();
        if (superType.isEntityType()) {
            return this.graph.putEntityType(this.getTypeNameOrThrow(name)).superType(superType.asEntityType());
        }
        if (superType.isRelationType()) {
            return this.graph.putRelationType(this.getTypeNameOrThrow(name)).superType(superType.asRelationType());
        }
        if (superType.isRoleType()) {
            return this.graph.putRoleType(this.getTypeNameOrThrow(name)).superType(superType.asRoleType());
        }
        if (superType.isResourceType()) {
            return this.graph.putResourceType(this.getTypeNameOrThrow(name), this.getDataType(var)).superType(superType.asResourceType());
        }
        if (superType.isRuleType()) {
            return this.graph.putRuleType(this.getTypeNameOrThrow(name)).superType(superType.asRuleType());
        }
        throw new RuntimeException("Unrecognized type " + superType.getName());
    }

    private <T extends Type, S extends Instance> S addOrGetInstance(Optional<String> id, Supplier<S> addInstance) {
        return (S)id.map(arg_0 -> ((GraknGraph)this.graph).getConcept(arg_0)).orElseGet(addInstance);
    }

    private String getTypeNameOrThrow(Optional<String> name) throws IllegalStateException {
        return name.orElseThrow(() -> new IllegalStateException(ErrorMessage.INSERT_TYPE_WITHOUT_NAME.getMessage(new Object[0])));
    }

    private Object getValue(VarAdmin var) {
        Iterator properties = var.getProperties(ValueProperty.class).iterator();
        if (properties.hasNext()) {
            Object value = ((ValueProperty)properties.next()).getPredicate().equalsValue().get();
            if (properties.hasNext()) {
                throw new IllegalStateException(ErrorMessage.INSERT_MULTIPLE_VALUES.getMessage(new Object[]{value, ((ValueProperty)properties.next()).getPredicate()}));
            }
            return value;
        }
        throw new IllegalStateException(ErrorMessage.INSERT_RESOURCE_WITHOUT_VALUE.getMessage(new Object[0]));
    }

    private ResourceType.DataType<?> getDataType(VarAdmin var) {
        Optional<ResourceType.DataType> directDataType = var.getProperty(DataTypeProperty.class).map(DataTypeProperty::getDatatype);
        Optional<ResourceType.DataType> indirectDataType = this.getSub(var).map(sub -> this.getConcept((VarAdmin)sub).asResourceType().getDataType());
        Optional dataType = CommonUtil.optionalOr(directDataType, indirectDataType);
        return (ResourceType.DataType)dataType.orElseThrow(() -> new IllegalStateException(ErrorMessage.INSERT_NO_DATATYPE.getMessage(new Object[]{var.getPrintableName()})));
    }

    private Optional<VarAdmin> getSub(VarAdmin var) {
        return var.getProperty(SubProperty.class).map(SubProperty::getSuperType);
    }
}

