/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.aggregate;

import ai.grakn.concept.Concept;
import ai.grakn.graql.Aggregate;
import ai.grakn.graql.internal.query.aggregate.AbstractAggregate;
import ai.grakn.graql.internal.query.aggregate.Aggregates;
import ai.grakn.graql.internal.query.aggregate.CountAggregate;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class AverageAggregate
extends AbstractAggregate<Map<String, Concept>, Optional<Double>> {
    private final String varName;
    private final CountAggregate countAggregate;
    private final Aggregate<Map<String, Concept>, Number> sumAggregate;

    AverageAggregate(String varName) {
        this.varName = varName;
        this.countAggregate = new CountAggregate();
        this.sumAggregate = Aggregates.sum(varName);
    }

    public Optional<Double> apply(Stream<? extends Map<String, Concept>> stream) {
        List list = stream.collect(Collectors.toList());
        long count = (Long)this.countAggregate.apply(list.stream());
        if (count == 0L) {
            return Optional.empty();
        }
        Number sum = (Number)this.sumAggregate.apply(list.stream());
        return Optional.of(sum.doubleValue() / (double)count);
    }

    public String toString() {
        return "average $" + this.varName;
    }
}

