/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.aggregate;

import ai.grakn.concept.Concept;
import ai.grakn.graql.Aggregate;
import ai.grakn.graql.internal.query.aggregate.AbstractAggregate;
import ai.grakn.graql.internal.query.aggregate.ListAggregate;
import java.util.Map;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class GroupAggregate<T>
extends AbstractAggregate<Map<String, Concept>, Map<Concept, T>> {
    private final String varName;
    private final Aggregate<? super Map<String, Concept>, T> innerAggregate;

    GroupAggregate(String varName, Aggregate<? super Map<String, Concept>, T> innerAggregate) {
        this.varName = varName;
        this.innerAggregate = innerAggregate;
    }

    public Map<Concept, T> apply(Stream<? extends Map<String, Concept>> stream) {
        Collector applyAggregate = Collectors.collectingAndThen(Collectors.toList(), list -> this.innerAggregate.apply(list.stream()));
        return stream.collect(Collectors.groupingBy(result -> (Concept)result.get(this.varName), applyAggregate));
    }

    public String toString() {
        if (this.innerAggregate instanceof ListAggregate) {
            return "group $" + this.varName;
        }
        return "group $" + this.varName + " " + this.innerAggregate.toString();
    }
}

