/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.aggregate;

import ai.grakn.concept.Concept;
import ai.grakn.graql.internal.query.aggregate.AbstractAggregate;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class MedianAggregate
extends AbstractAggregate<Map<String, Concept>, Optional<Number>> {
    private final String varName;

    MedianAggregate(String varName) {
        this.varName = varName;
    }

    public Optional<Number> apply(Stream<? extends Map<String, Concept>> stream) {
        List results = stream.map(result -> (Number)((Concept)result.get(this.varName)).asResource().getValue()).sorted().collect(Collectors.toList());
        int size = results.size();
        int halveFloor = Math.floorDiv(size - 1, 2);
        int halveCeiling = (int)Math.ceil((double)(size - 1) / 2.0);
        if (size == 0) {
            return Optional.empty();
        }
        if (size % 2 == 1) {
            return Optional.of(results.get(halveFloor));
        }
        return Optional.of((((Number)results.get(halveFloor)).doubleValue() + ((Number)results.get(halveCeiling)).doubleValue()) / 2.0);
    }

    public String toString() {
        return "median $" + this.varName;
    }
}

