/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.Grakn;
import ai.grakn.GraknGraph;
import ai.grakn.concept.ResourceType;
import ai.grakn.concept.Type;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.internal.query.analytics.AbstractComputeQuery;
import ai.grakn.graql.internal.util.StringConverter;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

abstract class AbstractStatisticsQuery<T>
extends AbstractComputeQuery<T> {
    Set<String> statisticsResourceTypeNames = new HashSet<String>();
    private final Map<String, String> resourceTypesDataTypeMap = new HashMap<String, String>();

    AbstractStatisticsQuery() {
    }

    AbstractStatisticsQuery<T> setStatisticsResourceType(String ... statisticsResourceTypeNames) {
        this.statisticsResourceTypeNames = Sets.newHashSet((Object[])statisticsResourceTypeNames);
        return this;
    }

    AbstractStatisticsQuery<T> setStatisticsResourceType(Collection<String> statisticsResourceTypeNames) {
        this.statisticsResourceTypeNames = Sets.newHashSet(statisticsResourceTypeNames);
        return this;
    }

    public boolean isReadOnly() {
        return true;
    }

    @Override
    void initSubGraph() {
        super.initSubGraph();
        this.getResourceTypes((GraknGraph)this.graph.get());
    }

    @Override
    final String graqlString() {
        return this.getName() + this.resourcesString() + this.subtypeString();
    }

    abstract String getName();

    final String resourcesString() {
        return " of " + this.statisticsResourceTypeNames.stream().map(StringConverter::idToString).collect(Collectors.joining(", "));
    }

    private void getResourceTypes(GraknGraph graph) {
        if (this.statisticsResourceTypeNames.isEmpty()) {
            throw new IllegalStateException(ErrorMessage.RESOURCE_TYPE_NOT_SPECIFIED.getMessage(new Object[0]));
        }
        Set statisticsResourceTypes = this.statisticsResourceTypeNames.stream().map(name -> {
            Type type = graph.getType(name);
            if (type == null) {
                throw new IllegalArgumentException(ErrorMessage.NAME_NOT_FOUND.getMessage(new Object[]{name}));
            }
            return type;
        }).collect(Collectors.toSet());
        for (Type type2 : statisticsResourceTypes) {
            type2.subTypes().forEach(subtype -> this.statisticsResourceTypeNames.add(subtype.getName()));
        }
        ResourceType metaResourceType = graph.admin().getMetaResourceType();
        metaResourceType.subTypes().stream().filter(type -> !type.equals(metaResourceType)).forEach(type -> this.resourceTypesDataTypeMap.put(type.asType().getName(), type.asResourceType().getDataType().getName()));
    }

    String checkSelectedResourceTypesHaveCorrectDataType(Set<String> types) {
        if (types == null || types.isEmpty()) {
            throw new IllegalStateException(ErrorMessage.ILLEGAL_ARGUMENT_EXCEPTION.getMessage(new Object[]{this.getClass().toString()}));
        }
        String dataType = null;
        for (String type : types) {
            if (!this.resourceTypesDataTypeMap.containsKey(type)) {
                throw new IllegalStateException(ErrorMessage.ILLEGAL_ARGUMENT_EXCEPTION.getMessage(new Object[]{this.getClass().toString()}));
            }
            if (!(dataType == null ? !(dataType = this.resourceTypesDataTypeMap.get(type)).equals(ResourceType.DataType.LONG.getName()) && !dataType.equals(ResourceType.DataType.DOUBLE.getName()) : !dataType.equals(this.resourceTypesDataTypeMap.get(type)))) continue;
            throw new IllegalStateException(ErrorMessage.ILLEGAL_ARGUMENT_EXCEPTION.getMessage(new Object[]{this.getClass().toString()}));
        }
        return dataType;
    }

    boolean selectedResourceTypesHaveInstance(Set<String> statisticsResourceTypes) {
        GraknGraph graph = Grakn.factory((String)"localhost:4567", (String)this.keySpace).getGraph();
        List checkResourceTypes = statisticsResourceTypes.stream().map(type -> Graql.var("x").has(type)).collect(Collectors.toList());
        List checkSubtypes = this.subTypeNames.stream().map(type -> Graql.var("x").isa(type)).collect(Collectors.toList());
        return (Boolean)graph.graql().infer(false).match(new Pattern[]{Graql.or(checkResourceTypes), Graql.or(checkSubtypes)}).ask().execute();
    }

    Set<String> getCombinedSubTypes() {
        Set<String> allSubTypes = this.statisticsResourceTypeNames.stream().map(arg_0 -> ((Schema.Resource)Schema.Resource.HAS_RESOURCE).getName(arg_0)).collect(Collectors.toSet());
        allSubTypes.addAll(this.subTypeNames);
        allSubTypes.addAll(this.statisticsResourceTypeNames);
        return allSubTypes;
    }
}

