/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.GraknGraph;
import ai.grakn.graql.analytics.MeanQuery;
import ai.grakn.graql.internal.analytics.DegreeVertexProgram;
import ai.grakn.graql.internal.analytics.MeanMapReduce;
import ai.grakn.graql.internal.query.analytics.AbstractStatisticsQuery;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;

class MeanQueryImpl
extends AbstractStatisticsQuery<Optional<Double>>
implements MeanQuery {
    MeanQueryImpl(Optional<GraknGraph> graph) {
        this.graph = graph;
    }

    public Optional<Double> execute() {
        LOGGER.info("MeanMapReduce is called");
        this.initSubGraph();
        String dataType = this.checkSelectedResourceTypesHaveCorrectDataType(this.statisticsResourceTypeNames);
        if (!this.selectedResourceTypesHaveInstance(this.statisticsResourceTypeNames)) {
            return Optional.empty();
        }
        Set<String> allSubTypes = this.getCombinedSubTypes();
        ComputerResult result = this.getGraphComputer().compute((VertexProgram)new DegreeVertexProgram(allSubTypes, this.statisticsResourceTypeNames), new MapReduce[]{new MeanMapReduce(this.statisticsResourceTypeNames, dataType)});
        Map mean = (Map)result.memory().get("GraknMapReduce.memoryKey");
        Map meanPair = (Map)mean.get("mean");
        LOGGER.info("MeanMapReduce is done");
        return Optional.of((Double)meanPair.get("S") / (Double)meanPair.get("C"));
    }

    public MeanQuery of(String ... resourceTypeNames) {
        return (MeanQuery)this.setStatisticsResourceType(resourceTypeNames);
    }

    public MeanQuery of(Collection<String> resourceTypeNames) {
        return (MeanQuery)this.setStatisticsResourceType(resourceTypeNames);
    }

    public MeanQuery in(String ... subTypeNames) {
        return (MeanQuery)super.in(subTypeNames);
    }

    public MeanQuery in(Collection<String> subTypeNames) {
        return (MeanQuery)super.in(subTypeNames);
    }

    public MeanQuery withGraph(GraknGraph graph) {
        return (MeanQuery)super.withGraph(graph);
    }

    @Override
    String getName() {
        return "mean";
    }
}

