/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.GraknGraph;
import ai.grakn.graql.analytics.MedianQuery;
import ai.grakn.graql.internal.analytics.MedianVertexProgram;
import ai.grakn.graql.internal.query.analytics.AbstractStatisticsQuery;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;

class MedianQueryImpl
extends AbstractStatisticsQuery<Optional<Number>>
implements MedianQuery {
    MedianQueryImpl(Optional<GraknGraph> graph) {
        this.graph = graph;
    }

    public Optional<Number> execute() {
        LOGGER.info("MedianVertexProgram is called");
        this.initSubGraph();
        String dataType = this.checkSelectedResourceTypesHaveCorrectDataType(this.statisticsResourceTypeNames);
        if (!this.selectedResourceTypesHaveInstance(this.statisticsResourceTypeNames)) {
            return Optional.empty();
        }
        Set<String> allSubTypes = this.getCombinedSubTypes();
        ComputerResult result = this.getGraphComputer().compute((VertexProgram)new MedianVertexProgram(allSubTypes, this.statisticsResourceTypeNames, dataType), new MapReduce[0]);
        LOGGER.info("MedianVertexProgram is done");
        return Optional.of(result.memory().get("medianVertexProgram.median"));
    }

    public MedianQuery of(String ... resourceTypeNames) {
        return (MedianQuery)this.setStatisticsResourceType(resourceTypeNames);
    }

    public MedianQuery of(Collection<String> resourceTypeNames) {
        return (MedianQuery)this.setStatisticsResourceType(resourceTypeNames);
    }

    public MedianQuery in(String ... subTypeNames) {
        return (MedianQuery)super.in(subTypeNames);
    }

    public MedianQuery in(Collection<String> subTypeNames) {
        return (MedianQuery)super.in(subTypeNames);
    }

    public MedianQuery withGraph(GraknGraph graph) {
        return (MedianQuery)super.withGraph(graph);
    }

    @Override
    String getName() {
        return "median";
    }
}

