/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.GraknGraph;
import ai.grakn.graql.analytics.StdQuery;
import ai.grakn.graql.internal.analytics.DegreeVertexProgram;
import ai.grakn.graql.internal.analytics.StdMapReduce;
import ai.grakn.graql.internal.query.analytics.AbstractStatisticsQuery;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;

class StdQueryImpl
extends AbstractStatisticsQuery<Optional<Double>>
implements StdQuery {
    StdQueryImpl(Optional<GraknGraph> graph) {
        this.graph = graph;
    }

    public Optional<Double> execute() {
        LOGGER.info("StdMapReduce is called");
        this.initSubGraph();
        String dataType = this.checkSelectedResourceTypesHaveCorrectDataType(this.statisticsResourceTypeNames);
        if (!this.selectedResourceTypesHaveInstance(this.statisticsResourceTypeNames)) {
            return Optional.empty();
        }
        Set<String> allSubTypes = this.getCombinedSubTypes();
        ComputerResult result = this.getGraphComputer().compute((VertexProgram)new DegreeVertexProgram(allSubTypes, this.statisticsResourceTypeNames), new MapReduce[]{new StdMapReduce(this.statisticsResourceTypeNames, dataType)});
        Map std = (Map)result.memory().get("GraknMapReduce.memoryKey");
        Map stdTuple = (Map)std.get("std");
        double squareSum = (Double)stdTuple.get("SM");
        double sum = (Double)stdTuple.get("S");
        double count = (Double)stdTuple.get("C");
        LOGGER.info("StdMapReduce is done");
        return Optional.of(Math.sqrt(squareSum / count - sum / count * (sum / count)));
    }

    public StdQuery of(String ... resourceTypeNames) {
        return (StdQuery)this.setStatisticsResourceType(resourceTypeNames);
    }

    public StdQuery of(Collection<String> resourceTypeNames) {
        return (StdQuery)this.setStatisticsResourceType(resourceTypeNames);
    }

    public StdQuery in(String ... subTypeNames) {
        return (StdQuery)super.in(subTypeNames);
    }

    public StdQuery in(Collection<String> subTypeNames) {
        return (StdQuery)super.in(subTypeNames);
    }

    public StdQuery withGraph(GraknGraph graph) {
        return (StdQuery)super.withGraph(graph);
    }

    @Override
    String getName() {
        return "std";
    }
}

