/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.analytics;

import ai.grakn.GraknGraph;
import ai.grakn.graql.analytics.SumQuery;
import ai.grakn.graql.internal.analytics.DegreeVertexProgram;
import ai.grakn.graql.internal.analytics.SumMapReduce;
import ai.grakn.graql.internal.query.analytics.AbstractStatisticsQuery;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.ComputerResult;
import org.apache.tinkerpop.gremlin.process.computer.MapReduce;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;

class SumQueryImpl
extends AbstractStatisticsQuery<Optional<Number>>
implements SumQuery {
    SumQueryImpl(Optional<GraknGraph> graph) {
        this.graph = graph;
    }

    public Optional<Number> execute() {
        LOGGER.info("SumMapReduce is called");
        this.initSubGraph();
        String dataType = this.checkSelectedResourceTypesHaveCorrectDataType(this.statisticsResourceTypeNames);
        if (!this.selectedResourceTypesHaveInstance(this.statisticsResourceTypeNames)) {
            return Optional.empty();
        }
        Set<String> allSubTypes = this.getCombinedSubTypes();
        ComputerResult result = this.getGraphComputer().compute((VertexProgram)new DegreeVertexProgram(allSubTypes, this.statisticsResourceTypeNames), new MapReduce[]{new SumMapReduce(this.statisticsResourceTypeNames, dataType)});
        Map sum = (Map)result.memory().get("GraknMapReduce.memoryKey");
        LOGGER.info("SumMapReduce is done");
        return Optional.of(sum.get("sum"));
    }

    public SumQuery of(String ... resourceTypeNames) {
        return (SumQuery)this.setStatisticsResourceType(resourceTypeNames);
    }

    public SumQuery of(Collection<String> resourceTypeNames) {
        return (SumQuery)this.setStatisticsResourceType(resourceTypeNames);
    }

    public SumQuery in(String ... subTypeNames) {
        return (SumQuery)super.in(subTypeNames);
    }

    public SumQuery in(Collection<String> subTypeNames) {
        return (SumQuery)super.in(subTypeNames);
    }

    public SumQuery withGraph(GraknGraph graph) {
        return (SumQuery)super.withGraph(graph);
    }

    @Override
    String getName() {
        return "sum";
    }
}

