/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.match;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.graql.Aggregate;
import ai.grakn.graql.AggregateQuery;
import ai.grakn.graql.AskQuery;
import ai.grakn.graql.DeleteQuery;
import ai.grakn.graql.Graql;
import ai.grakn.graql.InsertQuery;
import ai.grakn.graql.MatchQuery;
import ai.grakn.graql.Order;
import ai.grakn.graql.Printer;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.MatchQueryAdmin;
import ai.grakn.graql.admin.VarAdmin;
import ai.grakn.graql.internal.query.Queries;
import ai.grakn.graql.internal.query.match.MatchOrderImpl;
import ai.grakn.graql.internal.query.match.MatchQueryDistinct;
import ai.grakn.graql.internal.query.match.MatchQueryGraph;
import ai.grakn.graql.internal.query.match.MatchQueryLimit;
import ai.grakn.graql.internal.query.match.MatchQueryOffset;
import ai.grakn.graql.internal.query.match.MatchQueryOrder;
import ai.grakn.graql.internal.query.match.MatchQuerySelect;
import ai.grakn.graql.internal.util.ANSI;
import ai.grakn.graql.internal.util.AdminConverter;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface MatchQueryInternal
extends MatchQueryAdmin {
    public static String colorKeyword(String keyword) {
        return ANSI.color(keyword, "\u001b[34m");
    }

    public static String colorType(String type) {
        return ANSI.color(type, "\u001b[35m");
    }

    default public Stream<String> resultsString(Printer printer) {
        return this.stream().map(arg_0 -> ((Printer)printer).graqlString(arg_0));
    }

    default public boolean isReadOnly() {
        return true;
    }

    public Stream<Map<String, Concept>> stream(Optional<GraknGraph> var1);

    default public Stream<Map<String, Concept>> stream() {
        return this.stream(Optional.empty());
    }

    default public MatchQuery withGraph(GraknGraph graph) {
        return new MatchQueryGraph(graph, this);
    }

    default public MatchQuery limit(long limit) {
        return new MatchQueryLimit(this, limit);
    }

    default public MatchQuery offset(long offset) {
        return new MatchQueryOffset(this, offset);
    }

    default public MatchQuery distinct() {
        return new MatchQueryDistinct(this);
    }

    default public <S> AggregateQuery<S> aggregate(Aggregate<? super Map<String, Concept>, S> aggregate) {
        return Queries.aggregate(this.admin(), aggregate);
    }

    default public MatchQuery select(Set<String> names) {
        return new MatchQuerySelect(this, (ImmutableSet<String>)ImmutableSet.copyOf(names));
    }

    default public Stream<Concept> get(String name) {
        return this.stream().map(result -> (Concept)result.get(name));
    }

    default public AskQuery ask() {
        return Queries.ask((MatchQuery)this);
    }

    default public InsertQuery insert(Collection<? extends Var> vars) {
        ImmutableMultiset varAdmins = ImmutableMultiset.copyOf(AdminConverter.getVarAdmins(vars));
        return Queries.insert((ImmutableCollection<VarAdmin>)varAdmins, this.admin());
    }

    default public DeleteQuery delete(String ... names) {
        List deleters = Arrays.stream(names).map(Graql::var).collect(Collectors.toList());
        return this.delete(deleters);
    }

    default public DeleteQuery delete(Collection<? extends Var> deleters) {
        return Queries.delete(AdminConverter.getVarAdmins(deleters), (MatchQuery)this);
    }

    default public MatchQuery orderBy(String varName, Order order) {
        return new MatchQueryOrder(this, new MatchOrderImpl(varName, order));
    }
}

