/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.match;

import ai.grakn.concept.Concept;
import ai.grakn.graql.internal.query.match.MatchQueryInternal;
import ai.grakn.graql.internal.query.match.MatchQueryModifier;
import ai.grakn.util.ErrorMessage;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class MatchQuerySelect
extends MatchQueryModifier {
    private final ImmutableSet<String> names;

    MatchQuerySelect(MatchQueryInternal inner, ImmutableSet<String> names) {
        super(inner);
        if (names.isEmpty()) {
            throw new IllegalArgumentException(ErrorMessage.SELECT_NONE_SELECTED.getMessage(new Object[0]));
        }
        this.names = names;
    }

    @Override
    public Stream<Map<String, Concept>> transformStream(Stream<Map<String, Concept>> stream) {
        return stream.map(result -> Maps.filterKeys((Map)result, arg_0 -> this.names.contains(arg_0)));
    }

    @Override
    protected String modifierString() {
        return "select " + this.names.stream().map(s -> "$" + s).collect(Collectors.joining(", "));
    }

    @Override
    public Set<String> getSelectedNames() {
        return this.names;
    }
}

