/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.predicate;

import ai.grakn.graql.internal.query.predicate.ComparatorPredicate;
import ai.grakn.graql.internal.util.StringConverter;
import java.util.Optional;
import org.apache.tinkerpop.gremlin.process.traversal.P;

class EqPredicate
extends ComparatorPredicate {
    private final Object value;

    EqPredicate(Object value) {
        super(value);
        this.value = value;
    }

    @Override
    protected String getSymbol() {
        return "=";
    }

    @Override
    <V> P<V> gremlinPredicate(V value) {
        return P.eq(value);
    }

    public boolean isSpecific() {
        return true;
    }

    public Optional<Object> equalsValue() {
        return Optional.of(this.value);
    }

    @Override
    public String toString() {
        return StringConverter.valueToString(this.value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EqPredicate that = (EqPredicate)o;
        return this.value != null ? this.value.equals(that.value) : that.value == null;
    }

    @Override
    public int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }
}

