/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.query.predicate;

import ai.grakn.graql.admin.ValuePredicateAdmin;
import ai.grakn.graql.admin.VarAdmin;
import ai.grakn.graql.internal.util.StringConverter;
import ai.grakn.util.Schema;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.regex.Pattern;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Vertex;

class RegexPredicate
implements ValuePredicateAdmin {
    private final String pattern;

    RegexPredicate(String pattern) {
        this.pattern = pattern;
    }

    private P<Object> regexPredicate() {
        BiPredicate<Object, Object> predicate = (value, p) -> Pattern.matches((String)p, (String)value);
        return new P(predicate, (Object)this.pattern);
    }

    public Optional<P<Object>> getPredicate() {
        return Optional.of(this.regexPredicate());
    }

    public Optional<VarAdmin> getInnerVar() {
        return Optional.empty();
    }

    public void applyPredicate(GraphTraversal<Vertex, Vertex> traversal) {
        traversal.has(Schema.ConceptProperty.VALUE_STRING.name(), this.regexPredicate());
    }

    public String toString() {
        return "/" + StringConverter.escapeString(this.pattern) + "/";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegexPredicate that = (RegexPredicate)o;
        return this.pattern != null ? this.pattern.equals(that.pattern) : that.pattern == null;
    }

    public int hashCode() {
        return this.pattern != null ? this.pattern.hashCode() : 0;
    }
}

