/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.atom;

import ai.grakn.graql.admin.PatternAdmin;
import ai.grakn.graql.admin.VarAdmin;
import ai.grakn.graql.internal.pattern.Patterns;
import ai.grakn.graql.internal.reasoner.atom.Atomic;
import ai.grakn.graql.internal.reasoner.atom.predicate.Predicate;
import ai.grakn.graql.internal.reasoner.query.Query;
import ai.grakn.util.ErrorMessage;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class AtomBase
implements Atomic {
    protected String varName = null;
    protected PatternAdmin atomPattern = null;
    private Query parent = null;

    protected AtomBase(VarAdmin pattern, Query par) {
        this.atomPattern = pattern;
        this.varName = pattern.getVarName();
        this.parent = par;
    }

    protected AtomBase(AtomBase a) {
        this.atomPattern = Patterns.mergeVars(Sets.newHashSet((Object[])new VarAdmin[]{a.atomPattern.asVar()}));
        this.varName = this.atomPattern.asVar().getVarName();
    }

    @Override
    public abstract Atomic clone();

    public String toString() {
        return this.atomPattern.toString();
    }

    @Override
    public boolean containsVar(String name) {
        return this.getVarNames().contains(name);
    }

    @Override
    public boolean isUserDefinedName() {
        return this.atomPattern.asVar().isUserDefinedName();
    }

    @Override
    public String getVarName() {
        return this.varName;
    }

    @Override
    public Set<String> getVarNames() {
        return Sets.newHashSet((Object[])new String[]{this.varName});
    }

    public Set<String> getSelectedNames() {
        Set<String> vars = this.getParentQuery().getSelectedNames();
        vars.retainAll(this.getVarNames());
        return vars;
    }

    public boolean isValueUserDefinedName() {
        return false;
    }

    @Override
    public PatternAdmin getPattern() {
        return this.atomPattern;
    }

    @Override
    public Query getParentQuery() {
        return this.parent;
    }

    @Override
    public void setParentQuery(Query q) {
        this.parent = q;
    }

    private void setVarName(String var) {
        this.varName = var;
        this.atomPattern.asVar().setVarName(var);
    }

    @Override
    public void unify(String from, String to) {
        String var = this.getVarName();
        if (var.equals(from)) {
            this.setVarName(to);
        } else if (var.equals(to)) {
            this.setVarName("captured->" + var);
        }
    }

    @Override
    public void unify(Map<String, String> unifiers) {
        String var = this.getVarName();
        if (unifiers.containsKey(var)) {
            this.setVarName(unifiers.get(var));
        } else if (unifiers.containsValue(var)) {
            this.setVarName("captured->" + var);
        }
    }

    @Override
    public Map<String, String> getUnifiers(Atomic parentAtom) {
        if (parentAtom.getClass() != this.getClass()) {
            throw new IllegalArgumentException(ErrorMessage.UNIFICATION_ATOM_INCOMPATIBILITY.getMessage(new Object[0]));
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (!this.getVarName().equals(parentAtom.getVarName())) {
            map.put(this.getVarName(), parentAtom.getVarName());
        }
        return map;
    }

    public Set<Predicate> getPredicates() {
        return new HashSet<Predicate>();
    }
}

