/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.atom;

import ai.grakn.GraknGraph;
import ai.grakn.graql.admin.Conjunction;
import ai.grakn.graql.admin.PatternAdmin;
import ai.grakn.graql.admin.VarAdmin;
import ai.grakn.graql.internal.pattern.property.HasResourceProperty;
import ai.grakn.graql.internal.pattern.property.RelationProperty;
import ai.grakn.graql.internal.pattern.property.ValueProperty;
import ai.grakn.graql.internal.reasoner.atom.Atomic;
import ai.grakn.graql.internal.reasoner.atom.PropertyMapper;
import ai.grakn.graql.internal.reasoner.atom.binary.Relation;
import ai.grakn.graql.internal.reasoner.atom.binary.Resource;
import ai.grakn.graql.internal.reasoner.atom.binary.TypeAtom;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import ai.grakn.graql.internal.reasoner.atom.predicate.ValuePredicate;
import ai.grakn.graql.internal.reasoner.query.Query;
import ai.grakn.util.ErrorMessage;
import java.util.HashSet;
import java.util.Set;

public class AtomicFactory {
    public static Atomic create(PatternAdmin pattern) {
        if (!pattern.isVar()) {
            throw new IllegalArgumentException(ErrorMessage.PATTERN_NOT_VAR.getMessage(new Object[]{pattern.toString()}));
        }
        VarAdmin var = pattern.asVar();
        if (var.hasProperty(RelationProperty.class)) {
            return new Relation(var);
        }
        if (var.hasProperty(HasResourceProperty.class)) {
            return new Resource(var);
        }
        if (var.getId().isPresent()) {
            return new IdPredicate(var);
        }
        if (var.hasProperty(ValueProperty.class)) {
            return new ValuePredicate(var);
        }
        return new TypeAtom(var);
    }

    public static Atomic create(PatternAdmin pattern, Query parent) {
        if (!pattern.isVar()) {
            throw new IllegalArgumentException(ErrorMessage.PATTERN_NOT_VAR.getMessage(new Object[]{pattern.toString()}));
        }
        VarAdmin var = pattern.asVar();
        if (var.hasProperty(RelationProperty.class)) {
            return new Relation(var, parent);
        }
        if (var.hasProperty(HasResourceProperty.class)) {
            return new Resource(var, parent);
        }
        if (var.getId().isPresent()) {
            return new IdPredicate(var, parent);
        }
        if (var.hasProperty(ValueProperty.class)) {
            return new ValuePredicate(var, parent);
        }
        return new TypeAtom(var, parent);
    }

    public static Atomic create(Atomic atom, Query parent) {
        Atomic copy = atom.clone();
        copy.setParentQuery(parent);
        return copy;
    }

    public static Set<Atomic> createAtomSet(Conjunction<PatternAdmin> pattern, Query parent, GraknGraph graph) {
        HashSet<Atomic> atoms = new HashSet<Atomic>();
        pattern.getVars().stream().flatMap(var -> var.getProperties().flatMap(prop -> PropertyMapper.map(prop, var, (Set<VarAdmin>)pattern.getVars(), parent, graph).stream())).forEach(atoms::add);
        return atoms;
    }
}

