/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.atom;

import ai.grakn.concept.Concept;
import ai.grakn.graql.Graql;
import ai.grakn.graql.internal.pattern.property.NeqProperty;
import ai.grakn.graql.internal.reasoner.atom.AtomBase;
import ai.grakn.graql.internal.reasoner.atom.Atomic;
import ai.grakn.graql.internal.reasoner.query.Query;
import ai.grakn.graql.internal.reasoner.query.QueryAnswers;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Stream;

public class NotEquals
extends AtomBase {
    private String refVarName;
    public static BiFunction<Map<String, Concept>, NotEquals, Stream<Map<String, Concept>>> notEqualsFunction = (a, atom) -> NotEquals.notEqualsOperator(a, atom) ? Stream.empty() : Stream.of(a);

    public NotEquals(String varName, NeqProperty prop, Query parent) {
        super(Graql.var(varName).neq(Graql.var(prop.getProperty().replace("$", ""))).admin(), parent);
        this.refVarName = prop.getProperty().replace("$", "");
    }

    public NotEquals(NotEquals a) {
        super(a);
        this.refVarName = a.getReferenceVarName();
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        NotEquals a2 = (NotEquals)obj;
        return this.getVarName().equals(a2.getVarName()) && this.getReferenceVarName().equals(a2.getReferenceVarName());
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 37 + this.varName.hashCode();
        hashCode = hashCode * 37 + this.refVarName.hashCode();
        return hashCode;
    }

    @Override
    public boolean isEquivalent(Object obj) {
        return true;
    }

    @Override
    public int equivalenceHashCode() {
        return 1;
    }

    @Override
    public Atomic clone() {
        return new NotEquals(this);
    }

    private void setRefVarName(String var) {
        this.refVarName = var;
        this.atomPattern = Graql.var(this.varName).neq(Graql.var(var)).admin();
    }

    @Override
    public void unify(String from, String to) {
        super.unify(from, to);
        String var = this.getReferenceVarName();
        if (var.equals(from)) {
            this.setRefVarName(to);
        } else if (var.equals(to)) {
            this.setRefVarName("captured->" + var);
        }
    }

    @Override
    public void unify(Map<String, String> unifiers) {
        super.unify(unifiers);
        String var = this.getReferenceVarName();
        if (unifiers.containsKey(var)) {
            this.setRefVarName(unifiers.get(var));
        } else if (unifiers.containsValue(var)) {
            this.setRefVarName("captured->" + var);
        }
    }

    public String getReferenceVarName() {
        return this.refVarName;
    }

    public static boolean notEqualsOperator(Map<String, Concept> answer, NotEquals atom) {
        return answer.get(atom.varName).equals(answer.get(atom.refVarName));
    }

    public QueryAnswers filter(QueryAnswers answers) {
        QueryAnswers results = new QueryAnswers();
        answers.stream().filter((? super T answer) -> !((Concept)answer.get(this.varName)).equals(answer.get(this.refVarName))).forEach(results::add);
        return results;
    }

    public Stream<Map<String, Concept>> filter(Stream<Map<String, Concept>> answers) {
        return answers.filter((? super T answer) -> !((Concept)answer.get(this.varName)).equals(answer.get(this.refVarName)));
    }
}

