/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.atom.binary;

import ai.grakn.graql.admin.VarAdmin;
import ai.grakn.graql.internal.reasoner.atom.Atom;
import ai.grakn.graql.internal.reasoner.atom.Atomic;
import ai.grakn.graql.internal.reasoner.atom.AtomicFactory;
import ai.grakn.graql.internal.reasoner.atom.predicate.Predicate;
import ai.grakn.graql.internal.reasoner.query.Query;
import ai.grakn.graql.internal.reasoner.rule.InferenceRule;
import ai.grakn.util.ErrorMessage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class Binary
extends Atom {
    private Predicate predicate = null;
    private String valueVariable;

    protected Binary(VarAdmin pattern, Predicate p, Query par) {
        super(pattern, par);
        this.valueVariable = this.extractValueVariableName(pattern);
        this.predicate = p;
        this.typeId = this.extractTypeId(this.atomPattern.asVar());
    }

    protected Binary(Binary a) {
        super(a);
        this.valueVariable = a.getValueVariable();
        this.predicate = a.getPredicate() != null ? (Predicate)AtomicFactory.create(a.getPredicate(), this.getParentQuery()) : null;
        this.typeId = this.extractTypeId(this.atomPattern.asVar());
    }

    @Override
    public void setParentQuery(Query q) {
        super.setParentQuery(q);
        if (this.predicate != null) {
            this.predicate.setParentQuery(q);
        }
    }

    protected abstract String extractTypeId(VarAdmin var1);

    protected abstract String extractValueVariableName(VarAdmin var1);

    public Predicate getPredicate() {
        return this.predicate;
    }

    protected void setPredicate(Predicate p) {
        this.predicate = p;
    }

    private boolean predicatesEquivalent(Binary atom) {
        Predicate pred = this.getPredicate();
        Predicate objPredicate = atom.getPredicate();
        return pred == null && objPredicate == null || pred != null && objPredicate != null && pred.isEquivalent(objPredicate);
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    @Override
    protected boolean isRuleApplicable(InferenceRule child) {
        Atom ruleAtom = child.getHead().getAtom();
        return ruleAtom instanceof Binary && this.getType().equals(ruleAtom.getType());
    }

    @Override
    public boolean requiresMaterialisation() {
        return this.isUserDefinedName() && this.getType() != null && this.getType().isRelationType();
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Binary a2 = (Binary)obj;
        return this.typeId.equals(a2.getTypeId()) && this.varName.equals(a2.getVarName()) && this.valueVariable.equals(a2.getValueVariable());
    }

    @Override
    public boolean isEquivalent(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Binary a2 = (Binary)obj;
        return this.typeId.equals(a2.getTypeId()) && this.predicatesEquivalent(a2);
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 37 + this.typeId.hashCode();
        hashCode = hashCode * 37 + this.varName.hashCode();
        hashCode = hashCode * 37 + this.valueVariable.hashCode();
        return hashCode;
    }

    @Override
    public int equivalenceHashCode() {
        int hashCode = 1;
        hashCode = hashCode * 37 + this.typeId.hashCode();
        hashCode = hashCode * 37 + (this.predicate != null ? this.predicate.equivalenceHashCode() : 0);
        return hashCode;
    }

    @Override
    public String getValueVariable() {
        return this.valueVariable;
    }

    protected void setValueVariable(String var) {
        this.valueVariable = var;
    }

    @Override
    public boolean isValueUserDefinedName() {
        return this.predicate == null;
    }

    @Override
    public Set<Predicate> getIdPredicates() {
        return this.getParentQuery().getIdPredicates().stream().filter(atom -> this.containsVar(atom.getVarName())).collect(Collectors.toSet());
    }

    @Override
    public Set<Predicate> getValuePredicates() {
        return new HashSet<Predicate>();
    }

    @Override
    public Set<Predicate> getPredicates() {
        Set<Predicate> predicates = this.getValuePredicates();
        predicates.addAll(this.getIdPredicates());
        return predicates;
    }

    public Set<Atom> getLinkedAtoms() {
        HashSet<Atom> atoms = new HashSet<Atom>();
        this.getParentQuery().getAtoms().stream().filter(Atomic::isAtom).map(atom -> (Atom)atom).filter(Atom::isBinary).map(atom -> (Binary)atom).filter(atom -> atom.getVarName().equals(this.valueVariable)).forEach(atom -> {
            atoms.add((Atom)atom);
            atoms.addAll(atom.getLinkedAtoms());
        });
        return atoms;
    }

    @Override
    public Set<String> getVarNames() {
        HashSet<String> vars = new HashSet<String>();
        if (this.isUserDefinedName()) {
            vars.add(this.getVarName());
        }
        if (!this.valueVariable.isEmpty()) {
            vars.add(this.valueVariable);
        }
        return vars;
    }

    @Override
    public Set<String> getSelectedNames() {
        Set<String> vars = super.getSelectedNames();
        if (this.isUserDefinedName()) {
            vars.add(this.getVarName());
        }
        if (this.isValueUserDefinedName()) {
            vars.add(this.getValueVariable());
        }
        return vars;
    }

    @Override
    public void unify(String from, String to) {
        super.unify(from, to);
        String var = this.valueVariable;
        if (var.equals(from)) {
            this.setValueVariable(to);
        } else if (var.equals(to)) {
            this.setValueVariable("captured->" + var);
        }
        if (this.predicate != null) {
            this.predicate.unify(from, to);
        }
    }

    @Override
    public void unify(Map<String, String> unifiers) {
        super.unify(unifiers);
        String var = this.valueVariable;
        if (unifiers.containsKey(var)) {
            this.setValueVariable(unifiers.get(var));
        } else if (unifiers.containsValue(var)) {
            this.setValueVariable("captured->" + var);
        }
        if (this.predicate != null) {
            this.predicate.unify(unifiers);
        }
    }

    @Override
    public Map<String, String> getUnifiers(Atomic parentAtom) {
        String parentVarName;
        String childVarName;
        if (!(parentAtom instanceof Binary)) {
            throw new IllegalArgumentException(ErrorMessage.UNIFICATION_ATOM_INCOMPATIBILITY.getMessage(new Object[0]));
        }
        HashMap<String, String> unifiers = new HashMap<String, String>();
        String childValVarName = this.getValueVariable();
        String parentValVarName = ((Binary)parentAtom).getValueVariable();
        if (parentAtom.isUserDefinedName() && !(childVarName = this.getVarName()).equals(parentVarName = parentAtom.getVarName())) {
            unifiers.put(childVarName, parentVarName);
        }
        if (!parentValVarName.isEmpty() && !childValVarName.equals(parentValVarName)) {
            unifiers.put(childValVarName, parentValVarName);
        }
        return unifiers;
    }
}

