/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.atom.binary;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.concept.RelationType;
import ai.grakn.concept.RoleType;
import ai.grakn.concept.Rule;
import ai.grakn.concept.Type;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Reasoner;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.RelationPlayer;
import ai.grakn.graql.admin.VarAdmin;
import ai.grakn.graql.internal.pattern.property.IsaProperty;
import ai.grakn.graql.internal.pattern.property.RelationProperty;
import ai.grakn.graql.internal.reasoner.Utility;
import ai.grakn.graql.internal.reasoner.atom.Atom;
import ai.grakn.graql.internal.reasoner.atom.Atomic;
import ai.grakn.graql.internal.reasoner.atom.binary.HasRole;
import ai.grakn.graql.internal.reasoner.atom.binary.TypeAtom;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import ai.grakn.graql.internal.reasoner.atom.predicate.Predicate;
import ai.grakn.graql.internal.reasoner.query.AtomicMatchQuery;
import ai.grakn.graql.internal.reasoner.query.Query;
import ai.grakn.graql.internal.reasoner.rule.InferenceRule;
import ai.grakn.graql.internal.util.CommonUtil;
import ai.grakn.util.ErrorMessage;
import ai.grakn.util.Schema;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javafx.util.Pair;

public class Relation
extends TypeAtom {
    private Set<RelationPlayer> relationPlayers;
    private Map<RoleType, Pair<String, Type>> roleVarTypeMap = null;
    private Map<String, Pair<Type, RoleType>> varTypeRoleMap = null;

    public Relation(VarAdmin pattern) {
        this(pattern, null, null);
    }

    public Relation(VarAdmin pattern, Query par) {
        this(pattern, null, par);
    }

    public Relation(VarAdmin pattern, Predicate predicate, Query par) {
        super(pattern, predicate, par);
        this.relationPlayers = this.getRelationPlayers(pattern);
    }

    public Relation(String name, String typeVariable, Map<String, String> roleMap, Predicate pred, Query par) {
        super(Relation.constructRelationVar(name, typeVariable, roleMap), pred, par);
        this.relationPlayers = this.getRelationPlayers(this.getPattern().asVar());
    }

    private Relation(Relation a) {
        super(a);
        this.relationPlayers = this.getRelationPlayers(a.getPattern().asVar());
        this.roleVarTypeMap = a.roleVarTypeMap != null ? Maps.newHashMap(a.roleVarTypeMap) : null;
        this.varTypeRoleMap = a.varTypeRoleMap != null ? Maps.newHashMap(a.varTypeRoleMap) : null;
    }

    private Set<RelationPlayer> getRelationPlayers() {
        return this.getRelationPlayers(this.atomPattern.asVar());
    }

    private Set<RelationPlayer> getRelationPlayers(VarAdmin pattern) {
        HashSet<RelationPlayer> rps = new HashSet<RelationPlayer>();
        pattern.getProperty(RelationProperty.class).ifPresent(prop -> prop.getRelationPlayers().forEach(rps::add));
        return rps;
    }

    @Override
    protected String extractValueVariableName(VarAdmin var) {
        IsaProperty isaProp = var.getProperty(IsaProperty.class).orElse(null);
        return isaProp != null ? isaProp.getType().getVarName() : "";
    }

    @Override
    protected void setValueVariable(String var) {
        IsaProperty isaProp = this.atomPattern.asVar().getProperty(IsaProperty.class).orElse(null);
        if (isaProp != null) {
            super.setValueVariable(var);
            this.atomPattern.asVar().getProperties(IsaProperty.class).forEach(prop -> prop.getType().setVarName(var));
        }
    }

    @Override
    public Atomic clone() {
        return new Relation(this);
    }

    private static VarAdmin constructRelationVar(String varName, String typeVariable, Map<String, String> roleMap) {
        Var var = !varName.isEmpty() ? Graql.var(varName) : Graql.var();
        roleMap.forEach((player, role) -> {
            if (role == null) {
                var.rel(player);
            } else {
                var.rel(role, player);
            }
        });
        var.isa(Graql.var(typeVariable));
        return var.admin().asVar();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Relation a2 = (Relation)obj;
        return this.getTypeId().equals(a2.getTypeId()) && this.getVarNames().equals(a2.getVarNames()) && this.relationPlayers.equals(a2.relationPlayers);
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = hashCode * 37 + this.getTypeId().hashCode();
        hashCode = hashCode * 37 + this.getVarNames().hashCode();
        return hashCode;
    }

    @Override
    public boolean isEquivalent(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Relation a2 = (Relation)obj;
        Map<RoleType, String> map = this.getRoleConceptIdMap();
        Map<RoleType, String> map2 = a2.getRoleConceptIdMap();
        return this.getTypeId().equals(a2.getTypeId()) && map.equals(map2);
    }

    @Override
    public int equivalenceHashCode() {
        int hashCode = 1;
        hashCode = hashCode * 37 + this.typeId.hashCode();
        hashCode = hashCode * 37 + this.getRoleConceptIdMap().hashCode();
        return hashCode;
    }

    @Override
    public boolean isRelation() {
        return true;
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    private boolean isRuleApplicableViaType(RelationType relType) {
        boolean ruleRelevant = true;
        Map<String, Type> varTypeMap = this.getParentQuery().getVarTypeMap();
        Iterator it = varTypeMap.entrySet().stream().filter(entry -> this.containsVar((String)entry.getKey())).iterator();
        while (it.hasNext() && ruleRelevant) {
            Map.Entry entry2 = (Map.Entry)it.next();
            Type type = (Type)entry2.getValue();
            if (type == null) continue;
            Collection roleIntersection = relType.hasRoles();
            roleIntersection.retainAll(type.playsRoles());
            ruleRelevant = !roleIntersection.isEmpty();
        }
        return ruleRelevant;
    }

    private boolean isRuleApplicableViaAtom(Atom childAtom, InferenceRule child) {
        boolean ruleRelevant = true;
        Query parent = this.getParentQuery();
        Map<RoleType, Pair<String, Type>> childRoleVarTypeMap = childAtom.getRoleVarTypeMap();
        Map<RoleType, Pair<String, Type>> parentRoleVarTypeMap = this.getRoleVarTypeMap();
        Iterator<Map.Entry<RoleType, Pair<String, Type>>> it = parentRoleVarTypeMap.entrySet().iterator();
        while (it.hasNext() && ruleRelevant) {
            Type chType;
            boolean roleCompatible;
            Map.Entry<RoleType, Pair<String, Type>> entry = it.next();
            RoleType parentRole = entry.getKey();
            Iterator<RoleType> childRolesIt = childRoleVarTypeMap.keySet().iterator();
            boolean bl = roleCompatible = !childRolesIt.hasNext();
            while (childRolesIt.hasNext() && !roleCompatible) {
                roleCompatible = Utility.checkTypesCompatible((Type)parentRole, (Type)childRolesIt.next());
            }
            ruleRelevant = roleCompatible;
            Type pType = (Type)entry.getValue().getValue();
            if (pType == null || !ruleRelevant || !childRoleVarTypeMap.containsKey(parentRole) || (chType = (Type)childRoleVarTypeMap.get(parentRole).getValue()) == null) continue;
            ruleRelevant = Utility.checkTypesCompatible(pType, chType);
            String chVar = (String)childRoleVarTypeMap.get(parentRole).getKey();
            String pVar = (String)entry.getValue().getKey();
            Predicate childPredicate = child.getBody().getIdPredicate(chVar);
            Predicate parentPredicate = parent.getIdPredicate(pVar);
            if (childPredicate == null || parentPredicate == null) continue;
            ruleRelevant &= childPredicate.getPredicateValue().equals(parentPredicate.getPredicateValue());
        }
        return ruleRelevant;
    }

    @Override
    protected boolean isRuleApplicable(InferenceRule child) {
        Atom ruleAtom = child.getRuleConclusionAtom();
        if (!(ruleAtom instanceof Relation)) {
            return false;
        }
        Relation childAtom = (Relation)ruleAtom;
        if (childAtom.getRelationPlayers().size() < this.getRelationPlayers().size()) {
            return false;
        }
        Type type = this.getType();
        if (type == null) {
            return this.isRuleApplicableViaType((RelationType)childAtom.getType());
        }
        return this.isRuleApplicableViaAtom(childAtom, child);
    }

    @Override
    public boolean isRuleResolvable() {
        Type t = this.getType();
        if (t != null) {
            return !t.getRulesOfConclusion().isEmpty() && !this.getApplicableRules().isEmpty();
        }
        GraknGraph graph = this.getParentQuery().graph();
        Set<Rule> rules = Reasoner.getRules(graph);
        return rules.stream().flatMap(rule -> rule.getConclusionTypes().stream()).filter(Concept::isRelationType).count() != 0L & !this.getApplicableRules().isEmpty();
    }

    private boolean hasExplicitRoleTypes() {
        boolean rolesDefined = false;
        Iterator<RelationPlayer> it = this.relationPlayers.iterator();
        while (it.hasNext() && !rolesDefined) {
            rolesDefined = it.next().getRoleType().isPresent();
        }
        return rolesDefined;
    }

    private Set<RoleType> getExplicitRoleTypes() {
        HashSet<RoleType> roleTypes = new HashSet<RoleType>();
        GraknGraph graph = this.getParentQuery().graph();
        this.relationPlayers.stream().map(RelationPlayer::getRoleType).flatMap(CommonUtil::optionalToStream).map(VarAdmin::getTypeName).flatMap(CommonUtil::optionalToStream).map(arg_0 -> ((GraknGraph)graph).getRoleType(arg_0)).forEach(roleTypes::add);
        return roleTypes;
    }

    private void addPredicate(Predicate pred) {
        if (this.getParentQuery() == null) {
            throw new IllegalStateException("No parent in addPredicate");
        }
        Query parent = this.getParentQuery();
        pred.setParentQuery(parent);
        this.setPredicate(pred);
        this.getParentQuery().addAtom(pred);
    }

    private void addType(Type type) {
        this.typeId = type.getId();
        String typeVariable = "rel-" + UUID.randomUUID().toString();
        this.addPredicate(new IdPredicate(Graql.var(typeVariable).id(this.typeId).admin()));
        this.atomPattern = this.atomPattern.asVar().isa(Graql.var(typeVariable)).admin();
        this.setValueVariable(typeVariable);
    }

    private void inferTypeFromRoles() {
        if (this.getParentQuery() != null && this.getTypeId().isEmpty() && this.hasExplicitRoleTypes()) {
            this.type = this.getExplicitRoleTypes().iterator().next().relationType();
            this.addType(this.type);
        }
    }

    private void inferTypeFromHasRole() {
        if (this.getPredicate() == null && this.getParentQuery() != null) {
            Query parent = this.getParentQuery();
            String valueVariable = this.getValueVariable();
            HasRole hrAtom = parent.getAtoms().stream().filter(at -> at.getVarName().equals(valueVariable)).filter(at -> at instanceof HasRole).map(at -> (HasRole)at).findFirst().orElse(null);
            if (hrAtom != null) {
                AtomicMatchQuery hrQuery = new AtomicMatchQuery(hrAtom, Sets.newHashSet((Object[])new String[]{hrAtom.getVarName()}));
                ((Query)hrQuery).DBlookup();
                if (((Query)hrQuery).getAnswers().size() != 1) {
                    throw new IllegalStateException("ambigious answer to has-role query");
                }
                IdPredicate newPredicate = new IdPredicate(IdPredicate.createIdVar(hrAtom.getVarName(), ((Concept)((Map)((Query)hrQuery).getAnswers().stream().findFirst().orElse(null)).get(hrAtom.getVarName())).getId()), parent);
                Relation newRelation = new Relation(this.getPattern().asVar(), newPredicate, parent);
                parent.removeAtom(hrAtom.getPredicate());
                parent.removeAtom(hrAtom);
                parent.removeAtom(this);
                parent.addAtom(newRelation);
                parent.addAtom(newPredicate);
            }
        }
    }

    @Override
    public void inferTypes() {
        this.inferTypeFromRoles();
        this.inferTypeFromHasRole();
    }

    @Override
    public boolean containsVar(String name) {
        boolean varFound = false;
        Iterator<RelationPlayer> it = this.relationPlayers.iterator();
        while (it.hasNext() && !varFound) {
            varFound = it.next().getRolePlayer().getVarName().equals(name);
        }
        return varFound;
    }

    @Override
    public Set<Predicate> getIdPredicates() {
        Set<Predicate> idPredicates = super.getIdPredicates();
        this.getTypeConstraints().forEach(atom -> {
            Predicate predicate = this.getParentQuery().getIdPredicate(atom.getValueVariable());
            if (predicate != null) {
                idPredicates.add(predicate);
            }
        });
        return idPredicates;
    }

    @Override
    public void unify(String from, String to) {
        super.unify(from, to);
        this.relationPlayers.forEach(c -> {
            String var = c.getRolePlayer().getVarName();
            if (var.equals(from)) {
                c.getRolePlayer().setVarName(to);
            } else if (var.equals(to)) {
                c.getRolePlayer().setVarName("captured->" + var);
            }
        });
    }

    @Override
    public void unify(Map<String, String> mappings) {
        super.unify(mappings);
        this.relationPlayers.forEach(c -> {
            String var = c.getRolePlayer().getVarName();
            if (mappings.containsKey(var)) {
                String target = (String)mappings.get(var);
                c.getRolePlayer().setVarName(target);
            } else if (mappings.containsValue(var)) {
                c.getRolePlayer().setVarName("captured->" + var);
            }
        });
    }

    @Override
    public Set<String> getVarNames() {
        Set<String> vars = super.getVarNames();
        vars.addAll(this.getRolePlayers());
        return vars;
    }

    @Override
    public Set<String> getSelectedNames() {
        Set<String> vars = super.getSelectedNames();
        vars.addAll(this.getRolePlayers());
        return vars;
    }

    public Set<String> getRolePlayers() {
        HashSet<String> vars = new HashSet<String>();
        this.relationPlayers.forEach(c -> vars.add(c.getRolePlayer().getVarName()));
        return vars;
    }

    private Map<String, Pair<Type, RoleType>> computeVarTypeRoleMap() {
        HashMap<String, Pair<Type, RoleType>> roleVarTypeMap = new HashMap<String, Pair<Type, RoleType>>();
        if (this.getParentQuery() == null) {
            return roleVarTypeMap;
        }
        GraknGraph graph = this.getParentQuery().graph();
        Type relType = this.getType();
        Set<String> vars = this.getRolePlayers();
        Map<String, Type> varTypeMap = this.getParentQuery().getVarTypeMap();
        for (String var : vars) {
            Type type = varTypeMap.get(var);
            String roleTypeName = "";
            for (RelationPlayer c : this.relationPlayers) {
                if (!c.getRolePlayer().getVarName().equals(var)) continue;
                roleTypeName = c.getRoleType().flatMap(VarAdmin::getTypeName).orElse("");
            }
            if (!roleTypeName.isEmpty()) {
                roleVarTypeMap.put(var, (Pair<Type, RoleType>)new Pair((Object)type, (Object)graph.getRoleType(roleTypeName)));
                continue;
            }
            if (type == null || relType == null) continue;
            Set<RoleType> cRoles = Utility.getCompatibleRoleTypes(type, relType);
            if (cRoles.size() == 1) {
                roleVarTypeMap.put(var, (Pair<Type, RoleType>)new Pair((Object)type, (Object)cRoles.iterator().next()));
                continue;
            }
            roleVarTypeMap.put(var, (Pair<Type, RoleType>)new Pair((Object)type, null));
        }
        return roleVarTypeMap;
    }

    @Override
    public Map<String, Pair<Type, RoleType>> getVarTypeRoleMap() {
        if (this.varTypeRoleMap == null) {
            this.varTypeRoleMap = this.computeVarTypeRoleMap();
        }
        return this.varTypeRoleMap;
    }

    private Map<RoleType, Pair<String, Type>> computeRoleVarTypeMap() {
        HashMap<RoleType, Pair<String, Type>> roleVarTypeMap = new HashMap<RoleType, Pair<String, Type>>();
        if (this.getParentQuery() == null || this.getType() == null) {
            return roleVarTypeMap;
        }
        GraknGraph graph = this.getParentQuery().graph();
        Map<String, Type> varTypeMap = this.getParentQuery().getVarTypeMap();
        HashSet allocatedVars = new HashSet();
        HashSet allocatedRoles = new HashSet();
        this.relationPlayers.forEach(c -> {
            String var = c.getRolePlayer().getVarName();
            String typeName = c.getRoleType().flatMap(VarAdmin::getTypeName).orElse("");
            if (!typeName.isEmpty()) {
                Type type = (Type)varTypeMap.get(var);
                RoleType role = graph.getRoleType(typeName);
                roleVarTypeMap.put(role, new Pair((Object)var, (Object)type));
                allocatedVars.add(var);
                allocatedRoles.add(role);
            }
        });
        RelationType relType = (RelationType)this.getType();
        Set<String> varsToAllocate = this.getRolePlayers();
        varsToAllocate.removeAll(allocatedVars);
        varsToAllocate.forEach(var -> {
            Set<RoleType> cRoles;
            Type type = (Type)varTypeMap.get(var);
            if (type != null && relType != null && (cRoles = Utility.getCompatibleRoleTypes(type, (Type)relType)).size() == 1) {
                RoleType role = cRoles.iterator().next();
                roleVarTypeMap.put(role, new Pair(var, (Object)type));
                allocatedVars.add(var);
                allocatedRoles.add(role);
            }
        });
        Collection rolesToAllocate = relType.hasRoles();
        allocatedRoles.forEach(role -> {
            RoleType topRole = Utility.getNonMetaTopRole(role);
            rolesToAllocate.removeAll(topRole.subTypes());
        });
        varsToAllocate.removeAll(allocatedVars);
        if (varsToAllocate.size() == 1 && !rolesToAllocate.isEmpty()) {
            RoleType topRole = Utility.getNonMetaTopRole((RoleType)rolesToAllocate.iterator().next());
            String var2 = varsToAllocate.iterator().next();
            Type type = varTypeMap.get(var2);
            roleVarTypeMap.put(topRole, (Pair<String, Type>)new Pair((Object)var2, (Object)type));
        }
        HashMap<String, String> roleMap = new HashMap<String, String>();
        roleVarTypeMap.forEach((r, tp) -> roleMap.put((String)tp.getKey(), r.getName()));
        this.getRolePlayers().stream().filter(var -> !var.equals(this.getVarName())).filter(var -> !roleMap.containsKey(var)).forEach(var -> {
            String cfr_ignored_0 = roleMap.put((String)var, (String)null);
        });
        this.atomPattern = Relation.constructRelationVar(this.isUserDefinedName() ? this.varName : "", this.getValueVariable(), roleMap);
        this.relationPlayers = this.getRelationPlayers(this.getPattern().asVar());
        return roleVarTypeMap;
    }

    @Override
    public Map<RoleType, Pair<String, Type>> getRoleVarTypeMap() {
        if (this.roleVarTypeMap == null) {
            if (this.varTypeRoleMap != null) {
                this.roleVarTypeMap = new HashMap<RoleType, Pair<String, Type>>();
                this.varTypeRoleMap.forEach((var, tpair) -> {
                    RoleType rt = (RoleType)tpair.getValue();
                    if (rt != null) {
                        this.roleVarTypeMap.put(rt, (Pair<String, Type>)new Pair(var, tpair.getKey()));
                    }
                });
            } else {
                this.roleVarTypeMap = this.computeRoleVarTypeMap();
            }
        }
        return this.roleVarTypeMap;
    }

    private Map<String, String> getRelationUnifiers(Relation parentAtom) {
        HashMap<String, String> unifiers = new HashMap<String, String>();
        Set<String> varsToAllocate = parentAtom.getRolePlayers();
        Set<String> childBVs = this.getRolePlayers();
        Map<String, Pair<Type, RoleType>> childMap = this.getVarTypeRoleMap();
        Map<RoleType, Pair<String, Type>> parentMap = parentAtom.getRoleVarTypeMap();
        childBVs.forEach(chVar -> {
            if (!varsToAllocate.isEmpty()) {
                String pVar = "";
                for (RoleType role = childMap.containsKey(chVar) ? (RoleType)((Pair)childMap.get(chVar)).getValue() : null; role != null && pVar.isEmpty() && !Schema.MetaSchema.isMetaName((String)role.getName()); role = role.superType()) {
                    if (!parentMap.containsKey(role)) continue;
                    pVar = (String)((Pair)parentMap.get(role)).getKey();
                }
                if (pVar.isEmpty()) {
                    pVar = (String)varsToAllocate.iterator().next();
                }
                if (!chVar.equals(pVar)) {
                    unifiers.put((String)chVar, pVar);
                }
                varsToAllocate.remove(pVar);
            }
        });
        return unifiers;
    }

    @Override
    public Map<String, String> getUnifiers(Atomic pAtom) {
        if (!(pAtom instanceof TypeAtom)) {
            throw new IllegalArgumentException(ErrorMessage.UNIFICATION_ATOM_INCOMPATIBILITY.getMessage(new Object[0]));
        }
        Map<String, String> unifiers = super.getUnifiers(pAtom);
        if (((Atom)pAtom).isRelation()) {
            unifiers.putAll(this.getRelationUnifiers((Relation)pAtom));
        }
        return unifiers;
    }

    private Map<String, Predicate> getVarSubMap() {
        HashMap<String, Predicate> map = new HashMap<String, Predicate>();
        this.getPredicates().stream().filter(Predicate::isIdPredicate).forEach(sub -> {
            String var = sub.getVarName();
            map.put(var, (Predicate)sub);
        });
        return map;
    }

    private Map<RoleType, String> getRoleConceptIdMap() {
        HashMap<RoleType, String> roleConceptMap = new HashMap<RoleType, String>();
        Map<String, Predicate> varSubMap = this.getVarSubMap();
        Map<RoleType, Pair<String, Type>> roleVarMap = this.getRoleVarTypeMap();
        roleVarMap.forEach((role, varTypePair) -> {
            String var = (String)varTypePair.getKey();
            roleConceptMap.put((RoleType)role, varSubMap.containsKey(var) ? ((Predicate)varSubMap.get(var)).getPredicateValue() : "");
        });
        return roleConceptMap;
    }

    @Override
    public Pair<Atom, Map<String, String>> rewrite(Atom parentAtom, Query parent) {
        if (parentAtom.isUserDefinedName()) {
            HashMap unifiers = new HashMap();
            VarAdmin var = this.getPattern().asVar();
            String varName = UUID.randomUUID().toString();
            Var relVar = Graql.var(varName);
            var.getProperty(IsaProperty.class).ifPresent(prop -> relVar.isa((Var)prop.getType()));
            ((RelationProperty)var.getProperty(RelationProperty.class).get()).getRelationPlayers().forEach(c -> {
                VarAdmin rolePlayer = c.getRolePlayer();
                String rolePlayerVarName = UUID.randomUUID().toString();
                unifiers.put(rolePlayer.getVarName(), rolePlayerVarName);
                Optional roleType = c.getRoleType();
                if (roleType.isPresent()) {
                    relVar.rel((Var)roleType.get(), rolePlayerVarName);
                } else {
                    relVar.rel(rolePlayerVarName);
                }
            });
            return new Pair((Object)new Relation(relVar.admin(), this.getPredicate(), parent), unifiers);
        }
        return new Pair((Object)this, new HashMap());
    }
}

