/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.atom.binary;

import ai.grakn.graql.admin.VarAdmin;
import ai.grakn.graql.internal.pattern.property.HasResourceProperty;
import ai.grakn.graql.internal.reasoner.atom.Atom;
import ai.grakn.graql.internal.reasoner.atom.Atomic;
import ai.grakn.graql.internal.reasoner.atom.binary.Binary;
import ai.grakn.graql.internal.reasoner.atom.predicate.Predicate;
import ai.grakn.graql.internal.reasoner.query.Query;
import ai.grakn.graql.internal.reasoner.rule.InferenceRule;
import java.util.Set;
import java.util.stream.Collectors;

public class Resource
extends Binary {
    public Resource(VarAdmin pattern) {
        this(pattern, null);
    }

    public Resource(VarAdmin pattern, Query par) {
        this(pattern, null, par);
    }

    public Resource(VarAdmin pattern, Predicate p, Query par) {
        super(pattern, p, par);
    }

    private Resource(Resource a) {
        super(a);
    }

    @Override
    protected boolean isRuleApplicable(InferenceRule child) {
        Atom ruleAtom = child.getHead().getAtom();
        if (!(ruleAtom instanceof Resource)) {
            return false;
        }
        Resource childAtom = (Resource)ruleAtom;
        Predicate childPredicate = childAtom.getPredicate();
        Predicate parentPredicate = this.getPredicate();
        return childPredicate == null || parentPredicate == null || parentPredicate.getPredicateValue().equals(childPredicate.getPredicateValue());
    }

    @Override
    protected String extractTypeId(VarAdmin var) {
        HasResourceProperty resProp = var.getProperties(HasResourceProperty.class).findFirst().orElse(null);
        return resProp != null ? resProp.getType().orElse("") : "";
    }

    @Override
    protected String extractValueVariableName(VarAdmin var) {
        HasResourceProperty prop = var.getProperties(HasResourceProperty.class).findFirst().orElse(null);
        VarAdmin resVar = prop.getResource();
        return resVar.isUserDefinedName() ? resVar.getVarName() : "";
    }

    @Override
    protected void setValueVariable(String var) {
        super.setValueVariable(var);
        this.atomPattern.asVar().getProperties(HasResourceProperty.class).forEach(prop -> prop.getResource().setVarName(var));
    }

    @Override
    public Atomic clone() {
        return new Resource(this);
    }

    @Override
    public boolean isResource() {
        return true;
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    @Override
    public boolean requiresMaterialisation() {
        return true;
    }

    @Override
    public Set<Predicate> getValuePredicates() {
        return this.getParentQuery().getValuePredicates().stream().filter(atom -> atom.getVarName().equals(this.getValueVariable())).collect(Collectors.toSet());
    }

    @Override
    public Set<String> getSelectedNames() {
        Set<String> vars = super.getSelectedNames();
        if (this.getPredicate() != null) {
            vars.addAll(this.getPredicate().getSelectedNames());
        }
        return vars;
    }
}

