/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.query;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.concept.Instance;
import ai.grakn.concept.Relation;
import ai.grakn.concept.RelationType;
import ai.grakn.concept.RoleType;
import ai.grakn.concept.Rule;
import ai.grakn.concept.Type;
import ai.grakn.graql.Graql;
import ai.grakn.graql.InsertQuery;
import ai.grakn.graql.MatchQuery;
import ai.grakn.graql.internal.reasoner.Utility;
import ai.grakn.graql.internal.reasoner.atom.Atom;
import ai.grakn.graql.internal.reasoner.atom.Atomic;
import ai.grakn.graql.internal.reasoner.atom.predicate.IdPredicate;
import ai.grakn.graql.internal.reasoner.query.Query;
import ai.grakn.graql.internal.reasoner.query.QueryAnswers;
import ai.grakn.graql.internal.reasoner.query.QueryCache;
import ai.grakn.util.ErrorMessage;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.util.Pair;

public class AtomicQuery
extends Query {
    private Atom atom;
    private AtomicQuery parent = null;
    private final Set<AtomicQuery> children = new HashSet<AtomicQuery>();

    public AtomicQuery(String rhs, GraknGraph graph) {
        super(rhs, graph);
        this.atom = this.selectAtoms().iterator().next();
    }

    public AtomicQuery(MatchQuery query, GraknGraph graph) {
        super(query, graph);
        this.atom = this.selectAtoms().iterator().next();
    }

    public AtomicQuery(AtomicQuery q) {
        super(q);
        this.atom = this.selectAtoms().stream().findFirst().orElse(null);
        this.parent = q.getParent();
        this.children.addAll(q.getChildren());
    }

    public AtomicQuery(Atom at, Set<String> vars) {
        super(at, vars);
        this.atom = this.selectAtoms().stream().findFirst().orElse(null);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        AtomicQuery a2 = (AtomicQuery)obj;
        return this.isEquivalent(a2);
    }

    private void addChild(AtomicQuery q) {
        if (!this.isEquivalent(q) && this.atom.getTypeId().equals(q.getAtom().getTypeId())) {
            this.children.add(q);
            q.setParent(this);
        }
    }

    private void setParent(AtomicQuery q) {
        this.parent = q;
    }

    public AtomicQuery getParent() {
        return this.parent;
    }

    public void establishRelation(AtomicQuery aq) {
        Atom aqAtom = aq.getAtom();
        if (this.atom.getTypeId().equals(aqAtom.getTypeId())) {
            if (this.atom.isRelation() && aqAtom.getRoleVarTypeMap().size() > this.atom.getRoleVarTypeMap().size()) {
                aq.addChild(this);
            } else {
                this.addChild(aq);
            }
        }
    }

    public Atom getAtom() {
        return this.atom;
    }

    public Set<AtomicQuery> getChildren() {
        return this.children;
    }

    @Override
    public boolean addAtom(Atomic at) {
        if (super.addAtom(at)) {
            if (this.atom == null && at.isSelectable()) {
                this.atom = (Atom)at;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAtom(Atomic at) {
        if (super.removeAtom(at)) {
            if (this.atom != null & at.equals(this.atom)) {
                this.atom = null;
            }
            return true;
        }
        return false;
    }

    private QueryAnswers materialiseComplete() {
        boolean dataPresent;
        Atom atom = this.getAtom();
        QueryAnswers insertAnswers = new QueryAnswers();
        boolean bl = dataPresent = atom.isResource() || atom.isUserDefinedName() && atom.getType().isRelationType() ? (Boolean)this.getMatchQuery().ask().execute() : false;
        if (!dataPresent) {
            InsertQuery insert = Graql.insert(this.getPattern().getVars()).withGraph(this.graph());
            Set insertedConcepts = insert.stream().collect(Collectors.toSet());
            if (atom.isUserDefinedName()) {
                insertedConcepts.stream().filter(c -> c.isResource() || c.isRelation()).forEach(c -> {
                    HashMap<String, Concept> answer = new HashMap<String, Concept>();
                    if (c.isResource()) {
                        answer.put(atom.getVarName(), this.graph().getConcept(this.getIdPredicate(atom.getVarName()).getPredicateValue()));
                        answer.put(atom.getValueVariable(), (Concept)c);
                    } else if (c.isRelation()) {
                        answer.put(atom.getVarName(), (Concept)c);
                        Map<RoleType, Pair<String, Type>> roleMap = atom.getRoleVarTypeMap();
                        Map<RoleType, Instance> roleplayers = ((Relation)c).rolePlayers().entrySet().stream().filter(entry -> entry.getValue() != null).filter(entry -> roleMap.containsKey(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                        roleplayers.entrySet().forEach(entry -> {
                            Concept cfr_ignored_0 = (Concept)answer.put((String)((Pair)roleMap.get(entry.getKey())).getKey(), (Concept)entry.getValue());
                        });
                    }
                    insertAnswers.add(answer);
                });
            }
        }
        return insertAnswers;
    }

    public QueryAnswers materialise() {
        return this.materialiseComplete();
    }

    public QueryAnswers materialise(Set<IdPredicate> subs) {
        QueryAnswers insertAnswers = new QueryAnswers();
        AtomicQuery queryToMaterialise = new AtomicQuery(this);
        subs.forEach(queryToMaterialise::addAtom);
        Atom at = queryToMaterialise.getAtom();
        if (at.isRelation()) {
            ai.grakn.graql.internal.reasoner.atom.binary.Relation relAtom = (ai.grakn.graql.internal.reasoner.atom.binary.Relation)at;
            Set<String> rolePlayers = relAtom.getRolePlayers();
            if (relAtom.getRoleVarTypeMap().size() != rolePlayers.size()) {
                RelationType relType = (RelationType)this.atom.getType();
                HashSet roles = Sets.newHashSet((Iterable)relType.hasRoles());
                HashSet<Map<String, String>> roleMaps = new HashSet<Map<String, String>>();
                Utility.computeRoleCombinations(rolePlayers, roles, new HashMap<String, String>(), roleMaps);
                queryToMaterialise.removeAtom(relAtom);
                roleMaps.forEach(roleMap -> {
                    ai.grakn.graql.internal.reasoner.atom.binary.Relation relationWithRoles = new ai.grakn.graql.internal.reasoner.atom.binary.Relation(this.atom.getVarName(), relAtom.getValueVariable(), (Map<String, String>)roleMap, relAtom.getPredicate(), queryToMaterialise);
                    queryToMaterialise.addAtom(relationWithRoles);
                    insertAnswers.addAll(queryToMaterialise.materialiseComplete());
                    queryToMaterialise.removeAtom(relationWithRoles);
                });
            } else {
                insertAnswers.addAll(queryToMaterialise.materialiseComplete());
            }
        } else {
            insertAnswers.addAll(queryToMaterialise.materialiseComplete());
        }
        return insertAnswers;
    }

    @Override
    public void unify(Map<String, String> unifiers) {
        super.unify(unifiers);
        this.atom = this.selectAtoms().iterator().next();
    }

    @Override
    public Set<Atom> selectAtoms() {
        Set<Atom> selectedAtoms = super.selectAtoms();
        if (selectedAtoms.size() != 1) {
            throw new IllegalStateException(ErrorMessage.NON_ATOMIC_QUERY.getMessage(new Object[]{this.toString()}));
        }
        return selectedAtoms;
    }

    public void resolveViaRule(Rule rl, Set<AtomicQuery> subGoals, QueryCache cache, boolean materialise) {
        throw new IllegalStateException(ErrorMessage.ANSWER_ERROR.getMessage(new Object[0]));
    }

    public QueryAnswers answer(Set<AtomicQuery> subGoals, QueryCache cache, boolean materialise) {
        throw new IllegalStateException(ErrorMessage.ANSWER_ERROR.getMessage(new Object[0]));
    }
}

