/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.query;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Concept;
import ai.grakn.concept.Type;
import ai.grakn.graql.internal.reasoner.Utility;
import ai.grakn.graql.internal.reasoner.atom.Atom;
import ai.grakn.graql.internal.reasoner.atom.NotEquals;
import ai.grakn.graql.internal.reasoner.atom.binary.Binary;
import ai.grakn.graql.internal.reasoner.atom.predicate.Predicate;
import ai.grakn.graql.internal.reasoner.query.AtomicQuery;
import ai.grakn.graql.internal.reasoner.query.Query;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class QueryAnswers
extends HashSet<Map<String, Concept>> {
    public QueryAnswers() {
    }

    public QueryAnswers(Collection<? extends Map<String, Concept>> ans) {
        super(ans);
    }

    public Set<String> getVars() {
        Optional map = this.stream().findFirst();
        return map.isPresent() ? ((Map)map.get()).keySet() : new HashSet();
    }

    public QueryAnswers filterVars(Set<String> vars) {
        QueryAnswers results = new QueryAnswers();
        if (this.isEmpty()) {
            return results;
        }
        this.forEach(answer -> {
            HashMap map = new HashMap();
            answer.forEach((? super K var, ? super V concept) -> {
                if (vars.contains(var)) {
                    map.put(var, concept);
                }
            });
            if (!map.isEmpty()) {
                results.add(map);
            }
        });
        return new QueryAnswers(results.stream().distinct().collect(Collectors.toSet()));
    }

    public QueryAnswers filterKnown(QueryAnswers known) {
        if (this.getVars().equals(known.getVars())) {
            QueryAnswers results = new QueryAnswers(this);
            results.removeAll(known);
            return results;
        }
        QueryAnswers results = new QueryAnswers();
        this.forEach(answer -> {
            boolean isKnown = false;
            Iterator it = known.iterator();
            while (it.hasNext() && !isKnown) {
                Map knownAnswer = (Map)it.next();
                isKnown = knownAnswer.entrySet().containsAll(answer.entrySet());
            }
            if (!isKnown) {
                results.add(answer);
            }
        });
        return results;
    }

    public QueryAnswers filterIncomplete(Set<String> vars) {
        return new QueryAnswers(this.stream().filter(answer -> answer.size() == vars.size()).collect(Collectors.toSet()));
    }

    public QueryAnswers filterNonEquals(Query query) {
        Set filters = query.getAtoms().stream().filter(at -> at.getClass() == NotEquals.class).map(at -> (NotEquals)at).collect(Collectors.toSet());
        if (filters.isEmpty()) {
            return this;
        }
        QueryAnswers results = new QueryAnswers(this);
        for (NotEquals filter : filters) {
            results = filter.filter(results);
        }
        return results;
    }

    public QueryAnswers filterByTypes(Set<String> vars, Map<String, Type> varTypeMap) {
        QueryAnswers results = new QueryAnswers();
        if (this.isEmpty()) {
            return results;
        }
        HashMap filteredMap = new HashMap();
        varTypeMap.forEach((? super K v, ? super V t) -> {
            if (vars.contains(v)) {
                filteredMap.put(v, t);
            }
        });
        if (filteredMap.isEmpty()) {
            return this;
        }
        this.forEach(answer -> {
            boolean isCompatible = true;
            Iterator it = filteredMap.entrySet().iterator();
            while (it.hasNext() && isCompatible) {
                Map.Entry entry = it.next();
                isCompatible = ((Concept)answer.get(entry.getKey())).asInstance().type().equals(entry.getValue());
            }
            if (isCompatible) {
                results.add(answer);
            }
        });
        return results;
    }

    public QueryAnswers join(QueryAnswers localTuples) {
        if (this.isEmpty() || localTuples.isEmpty()) {
            return new QueryAnswers();
        }
        QueryAnswers join = new QueryAnswers();
        for (Map lanswer : localTuples) {
            for (Map answer : this) {
                boolean isCompatible = true;
                Iterator it = lanswer.entrySet().iterator();
                while (it.hasNext() && isCompatible) {
                    Map.Entry entry = it.next();
                    String var = (String)entry.getKey();
                    Concept concept = (Concept)entry.getValue();
                    if (!answer.containsKey(var) || concept.equals(answer.get(var))) continue;
                    isCompatible = false;
                }
                if (!isCompatible) continue;
                HashMap merged = new HashMap();
                merged.putAll(lanswer);
                merged.putAll(answer);
                join.add(merged);
            }
        }
        return join;
    }

    public QueryAnswers unify(Map<String, String> unifiers) {
        return this.unify(unifiers, new HashMap<String, Concept>(), new HashMap<String, Concept>(), new HashMap<String, String>());
    }

    private QueryAnswers unify(Map<String, String> unifiers, Map<String, Concept> subVars, Map<String, Concept> valueConstraints, Map<String, String> typeConstraints) {
        if (unifiers.isEmpty()) {
            return new QueryAnswers(this);
        }
        QueryAnswers unifiedAnswers = new QueryAnswers();
        this.forEach(entry -> {
            HashMap<String, Concept> answer = new HashMap<String, Concept>(subVars);
            boolean isCompatible = true;
            Iterator it = entry.keySet().iterator();
            while (it.hasNext() && isCompatible) {
                String var = (String)it.next();
                Concept con = (Concept)entry.get(var);
                if (unifiers.containsKey(var)) {
                    var = (String)unifiers.get(var);
                }
                if (valueConstraints.containsKey(var) && !((Concept)valueConstraints.get(var)).equals(con) || typeConstraints.containsKey(var) && !((String)typeConstraints.get(var)).equals(con.getId())) {
                    isCompatible = false;
                    continue;
                }
                answer.put(var, con);
            }
            if (isCompatible && !answer.isEmpty()) {
                unifiedAnswers.add(answer);
            }
        });
        return unifiedAnswers;
    }

    public static QueryAnswers getUnifiedAnswers(AtomicQuery parentQuery, AtomicQuery childQuery, QueryAnswers answers) {
        if (parentQuery == childQuery) {
            return new QueryAnswers(answers);
        }
        GraknGraph graph = childQuery.graph();
        Atom childAtom = childQuery.getAtom();
        Atom parentAtom = parentQuery.getAtom();
        Map<String, String> unifiers = childAtom.getUnifiers(parentAtom);
        HashMap<String, Concept> subVars = new HashMap<String, Concept>();
        HashMap<String, Concept> valueConstraints = new HashMap<String, Concept>();
        HashMap<String, String> typeConstraints = new HashMap<String, String>();
        Set<Atom> extraTypes = Utility.subtractSets(parentQuery.getTypeConstraints(), childQuery.getTypeConstraints());
        extraTypes.removeAll(childQuery.getTypeConstraints());
        extraTypes.stream().map(t -> (Binary)t).forEach(type -> {
            Predicate predicate = parentQuery.getIdPredicate(type.getValueVariable());
            if (predicate != null) {
                typeConstraints.put(type.getVarName(), predicate.getPredicateValue());
            }
        });
        if (parentQuery.getSelectedNames().size() != childQuery.getSelectedNames().size()) {
            Set<Predicate> extraSubs = Utility.subtractSets(parentQuery.getIdPredicates(), childQuery.getIdPredicates());
            extraSubs.forEach(sub -> {
                String var = sub.getVarName();
                Concept con = graph.getConcept(sub.getPredicateValue());
                if (unifiers.containsKey(var)) {
                    var = (String)unifiers.get(var);
                }
                if (childQuery.getSelectedNames().size() > parentQuery.getSelectedNames().size()) {
                    valueConstraints.put(var, con);
                } else {
                    subVars.put(var, con);
                }
            });
        }
        QueryAnswers unifiedAnswers = answers.unify(unifiers, subVars, valueConstraints, typeConstraints);
        return unifiedAnswers.filterVars(parentQuery.getSelectedNames()).filterIncomplete(parentQuery.getSelectedNames());
    }
}

