/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.reasoner.rule;

import ai.grakn.GraknGraph;
import ai.grakn.concept.Rule;
import ai.grakn.graql.Graql;
import ai.grakn.graql.internal.reasoner.atom.Atom;
import ai.grakn.graql.internal.reasoner.atom.Atomic;
import ai.grakn.graql.internal.reasoner.atom.binary.Binary;
import ai.grakn.graql.internal.reasoner.atom.predicate.Predicate;
import ai.grakn.graql.internal.reasoner.query.AtomicQuery;
import ai.grakn.graql.internal.reasoner.query.Query;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javafx.util.Pair;

public class InferenceRule {
    private final Query body;
    private final AtomicQuery head;

    public InferenceRule(Rule rule, GraknGraph graph) {
        this.body = new Query(Graql.match(rule.getLHS()), graph);
        this.head = new AtomicQuery(Graql.match(rule.getRHS()), graph);
    }

    public Query getBody() {
        return this.body;
    }

    public AtomicQuery getHead() {
        return this.head;
    }

    public Atom getRuleConclusionAtom() {
        Query ruleQuery = new Query(this.head);
        Atom atom = ruleQuery.selectAtoms().iterator().next();
        this.body.getAtoms().forEach(at -> ruleQuery.addAtom(at.clone()));
        return atom;
    }

    private void propagateConstraints(Atom parentAtom) {
        if (parentAtom.isRelation() || parentAtom.isResource()) {
            Set types = parentAtom.getTypeConstraints().stream().filter(type -> !this.body.containsEquivalentAtom((Atomic)type)).collect(Collectors.toSet());
            HashSet<Predicate> predicates = new HashSet<Predicate>();
            types.stream().map(type -> (Binary)type).filter(type -> type.getPredicate() != null).map(Binary::getPredicate).forEach(predicates::add);
            predicates.addAll(parentAtom.getPredicates());
            this.head.addAtomConstraints(predicates);
            this.body.addAtomConstraints(predicates);
            this.head.addAtomConstraints(types);
            this.body.addAtomConstraints(types);
        }
        this.head.selectAppend(parentAtom.getParentQuery().getSelectedNames());
    }

    private void rewriteHead(Atom parentAtom) {
        Atom childAtom = this.head.getAtom();
        Pair<Atom, Map<String, String>> rewrite = childAtom.rewrite(parentAtom, this.head);
        Map rewriteUnifiers = (Map)rewrite.getValue();
        Atom newAtom = (Atom)rewrite.getKey();
        if (newAtom != childAtom) {
            this.head.removeAtom(childAtom);
            this.head.addAtom(newAtom);
            this.unify(rewriteUnifiers);
            Set<String> varIntersection = this.body.getVarSet();
            varIntersection.retainAll(parentAtom.getVarNames());
            varIntersection.removeAll(rewriteUnifiers.keySet());
            varIntersection.forEach(var -> this.body.unify((String)var, UUID.randomUUID().toString()));
        }
    }

    private void unify(Map<String, String> unifiers) {
        this.head.unify(unifiers);
        this.body.unify(unifiers);
    }

    private void unifyViaAtom(Atom parentAtom) {
        Atom childAtom = this.getRuleConclusionAtom();
        Map<String, String> unifiers = childAtom.getUnifiers(parentAtom);
        this.unify(unifiers);
    }

    public void unify(Atom parentAtom) {
        this.rewriteHead(parentAtom);
        this.unifyViaAtom(parentAtom);
        this.propagateConstraints(parentAtom);
    }
}

