/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.template.macro;

import ai.grakn.graql.macro.Macro;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class DateMacro
implements Macro<String> {
    public String apply(List<Object> values) {
        if (values.size() != 2 && values.size() != 3) {
            throw new IllegalArgumentException("Wrong number of arguments [" + values.size() + "] to macro " + this.name());
        }
        String originalDate = values.get(0).toString();
        String originalFormat = values.get(1).toString();
        String newFormat = values.size() == 3 ? values.get(2).toString() : null;
        return this.convertDateFormat(originalDate, originalFormat, newFormat);
    }

    public String name() {
        return "date";
    }

    private String convertDateFormat(String originalDate, String originalFormat, String newFormat) {
        originalFormat = this.removeQuotes(originalFormat);
        SimpleDateFormat originalDateFormat = new SimpleDateFormat(originalFormat);
        try {
            Date date = originalDateFormat.parse(originalDate);
            if (newFormat == null) {
                return Long.toString(date.getTime());
            }
            SimpleDateFormat newDateFormat = new SimpleDateFormat(this.removeQuotes(newFormat));
            return newDateFormat.format(date);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Could not parse date " + originalDate + " using " + originalDateFormat.toPattern());
        }
    }

    private String removeQuotes(String str) {
        return str.replace("\"", "");
    }
}

