/*
 * Grakn - A Distributed Semantic Database
 * Copyright (C) 2016-2018 Grakn Labs Limited
 *
 * Grakn is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Grakn is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Grakn. If not, see <http://www.gnu.org/licenses/gpl.txt>.
 */

package ai.grakn.graql.internal.reasoner.utils.conversion;

import ai.grakn.concept.Role;
import java.util.stream.Stream;

/**
 * <p>
 * Implementation of {@link SchemaConceptConverter} allowing for conversion of role types to compatible types.
 * </p>
 *
 * @author Kasper Piskorski
 */
public class RoleConverter implements SchemaConceptConverter<Role> {

    @Override
    public Stream<Role> toCompatibleRoles(Role entryRole) {
        return entryRole.subs();
    }
}
