/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.analytics;

import ai.grakn.concept.ConceptId;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.internal.analytics.GraknVertexProgram;
import ai.grakn.util.Schema;
import java.util.Collections;
import java.util.Set;
import java.util.function.BinaryOperator;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.MemoryComputeKey;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;
import org.apache.tinkerpop.gremlin.process.computer.Messenger;
import org.apache.tinkerpop.gremlin.process.computer.VertexComputeKey;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class ConnectedComponentVertexProgram
extends GraknVertexProgram<Boolean> {
    private static final int MAX_ITERATION = 100;
    private static final String VOTE_TO_HALT = "connectedComponentVertexProgram.voteToHalt";
    private static final String SOURCE = "connectedComponentVertexProgram.source";
    private static final Boolean MESSAGE = true;
    private static final Set<MemoryComputeKey> MEMORY_COMPUTE_KEYS = Collections.singleton(MemoryComputeKey.of((String)"connectedComponentVertexProgram.voteToHalt", (BinaryOperator)Operator.and, (boolean)false, (boolean)true));

    public ConnectedComponentVertexProgram() {
    }

    public ConnectedComponentVertexProgram(ConceptId sourceId) {
        this.persistentProperties.put(SOURCE, sourceId.getValue());
    }

    public Set<VertexComputeKey> getVertexComputeKeys() {
        return Collections.singleton(VertexComputeKey.of((String)"connectedComponentVertexProgram.clusterLabel", (boolean)false));
    }

    public Set<MemoryComputeKey> getMemoryComputeKeys() {
        return MEMORY_COMPUTE_KEYS;
    }

    @Override
    public void setup(Memory memory) {
        LOGGER.debug("ConnectedComponentVertexProgram Started !!!!!!!!");
        memory.set(VOTE_TO_HALT, (Object)true);
    }

    @Override
    public void safeExecute(Vertex vertex, Messenger<Boolean> messenger, Memory memory) {
        if (memory.isInitialIteration()) {
            if (((String)vertex.value(Schema.VertexProperty.ID.name())).equals(this.persistentProperties.get(SOURCE))) {
                ConnectedComponentVertexProgram.update(vertex, messenger, memory, (String)this.persistentProperties.get(SOURCE));
            }
        } else if (messenger.receiveMessages().hasNext() && !vertex.property("connectedComponentVertexProgram.clusterLabel").isPresent()) {
            ConnectedComponentVertexProgram.update(vertex, messenger, memory, (String)this.persistentProperties.get(SOURCE));
        }
    }

    private static void update(Vertex vertex, Messenger<Boolean> messenger, Memory memory, String label) {
        messenger.sendMessage((MessageScope)messageScopeIn, (Object)MESSAGE);
        messenger.sendMessage((MessageScope)messageScopeOut, (Object)MESSAGE);
        vertex.property("connectedComponentVertexProgram.clusterLabel", (Object)label);
        memory.add(VOTE_TO_HALT, (Object)false);
    }

    public boolean terminate(Memory memory) {
        LOGGER.debug("Finished Iteration " + memory.getIteration());
        if (memory.isInitialIteration()) {
            return false;
        }
        if (((Boolean)memory.get(VOTE_TO_HALT)).booleanValue()) {
            return true;
        }
        if (memory.getIteration() == 100) {
            LOGGER.debug("Reached Max Iteration: 100 !!!!!!!!");
            throw GraqlQueryException.maxIterationsReached(this.getClass());
        }
        memory.set(VOTE_TO_HALT, (Object)true);
        return false;
    }
}

