/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.analytics;

import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.internal.analytics.GraknVertexProgram;
import ai.grakn.util.Schema;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.function.BinaryOperator;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.MemoryComputeKey;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;
import org.apache.tinkerpop.gremlin.process.computer.Messenger;
import org.apache.tinkerpop.gremlin.process.computer.VertexComputeKey;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class ConnectedComponentsVertexProgram
extends GraknVertexProgram<String> {
    private static final int MAX_ITERATION = 100;
    public static final String CLUSTER_LABEL = "connectedComponentVertexProgram.clusterLabel";
    private static final String VOTE_TO_HALT = "connectedComponentVertexProgram.voteToHalt";
    private static final Set<MemoryComputeKey> MEMORY_COMPUTE_KEYS = Collections.singleton(MemoryComputeKey.of((String)"connectedComponentVertexProgram.voteToHalt", (BinaryOperator)Operator.and, (boolean)false, (boolean)true));

    public Set<VertexComputeKey> getVertexComputeKeys() {
        return Collections.singleton(VertexComputeKey.of((String)CLUSTER_LABEL, (boolean)false));
    }

    public Set<MemoryComputeKey> getMemoryComputeKeys() {
        return MEMORY_COMPUTE_KEYS;
    }

    @Override
    public void setup(Memory memory) {
        LOGGER.debug("ConnectedComponentsVertexProgram Started !!!!!!!!");
        memory.set(VOTE_TO_HALT, (Object)true);
    }

    @Override
    public void safeExecute(Vertex vertex, Messenger<String> messenger, Memory memory) {
        if (memory.isInitialIteration()) {
            String id = (String)vertex.value(Schema.VertexProperty.ID.name());
            vertex.property(CLUSTER_LABEL, (Object)id);
            messenger.sendMessage((MessageScope)messageScopeIn, (Object)id);
            messenger.sendMessage((MessageScope)messageScopeOut, (Object)id);
        } else {
            ConnectedComponentsVertexProgram.updateClusterLabel(vertex, messenger, memory);
        }
    }

    private static void updateClusterLabel(Vertex vertex, Messenger<String> messenger, Memory memory) {
        String currentMax = (String)vertex.value(CLUSTER_LABEL);
        String max = (String)IteratorUtils.reduce((Iterator)messenger.receiveMessages(), (Object)currentMax, (a, b) -> a.compareTo((String)b) > 0 ? a : b);
        if (max.compareTo(currentMax) > 0) {
            vertex.property(CLUSTER_LABEL, (Object)max);
            messenger.sendMessage((MessageScope)messageScopeIn, (Object)max);
            messenger.sendMessage((MessageScope)messageScopeOut, (Object)max);
            memory.add(VOTE_TO_HALT, (Object)false);
        }
    }

    public boolean terminate(Memory memory) {
        LOGGER.debug("Finished Iteration " + memory.getIteration());
        if (memory.getIteration() < 2) {
            return false;
        }
        if (((Boolean)memory.get(VOTE_TO_HALT)).booleanValue()) {
            return true;
        }
        if (memory.getIteration() == 100) {
            LOGGER.debug("Reached Max Iteration: 100 !!!!!!!!");
            throw GraqlQueryException.maxIterationsReached(this.getClass());
        }
        memory.set(VOTE_TO_HALT, (Object)true);
        return false;
    }
}

