/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.analytics;

import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.internal.analytics.GraknVertexProgram;
import ai.grakn.graql.internal.analytics.KCoreVertexProgram;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.function.BinaryOperator;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.MemoryComputeKey;
import org.apache.tinkerpop.gremlin.process.computer.Messenger;
import org.apache.tinkerpop.gremlin.process.computer.VertexComputeKey;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class CorenessVertexProgram
extends GraknVertexProgram<String> {
    private static final int MAX_ITERATION = 200;
    private static final String EMPTY_MESSAGE = "";
    public static final String CORENESS = "corenessVertexProgram.coreness";
    private static final String PERSIST_CORENESS = "corenessVertexProgram.persistCoreness";
    private static final Set<MemoryComputeKey> MEMORY_COMPUTE_KEYS = Sets.newHashSet((Object[])new MemoryComputeKey[]{MemoryComputeKey.of((String)"kCoreVertexProgram.stable", (BinaryOperator)Operator.and, (boolean)false, (boolean)true), MemoryComputeKey.of((String)"kCoreVertexProgram.exist", (BinaryOperator)Operator.or, (boolean)false, (boolean)true), MemoryComputeKey.of((String)"corenessVertexProgram.persistCoreness", (BinaryOperator)Operator.assign, (boolean)true, (boolean)true), MemoryComputeKey.of((String)"kCoreVertexProgram.k", (BinaryOperator)Operator.assign, (boolean)true, (boolean)true)});
    private static final Set<VertexComputeKey> VERTEX_COMPUTE_KEYS = Sets.newHashSet((Object[])new VertexComputeKey[]{VertexComputeKey.of((String)"corenessVertexProgram.coreness", (boolean)false), VertexComputeKey.of((String)"kCoreVertexProgram.kCoreLabel", (boolean)true), VertexComputeKey.of((String)"corenessVertexProgram.messageCount", (boolean)true), VertexComputeKey.of((String)"kCoreVertexProgram.implicitMessageCount", (boolean)true)});

    public CorenessVertexProgram() {
    }

    public CorenessVertexProgram(long minK) {
        this.persistentProperties.put("kCoreVertexProgram.k", minK);
    }

    public Set<VertexComputeKey> getVertexComputeKeys() {
        return VERTEX_COMPUTE_KEYS;
    }

    public Set<MemoryComputeKey> getMemoryComputeKeys() {
        return MEMORY_COMPUTE_KEYS;
    }

    @Override
    public void setup(Memory memory) {
        LOGGER.debug("KCoreVertexProgram Started !!!!!!!!");
        memory.set("kCoreVertexProgram.stable", (Object)false);
        memory.set("kCoreVertexProgram.exist", (Object)false);
        memory.set(PERSIST_CORENESS, (Object)false);
        memory.set("kCoreVertexProgram.k", this.persistentProperties.get("kCoreVertexProgram.k"));
    }

    @Override
    public void safeExecute(Vertex vertex, Messenger<String> messenger, Memory memory) {
        switch (memory.getIteration()) {
            case 0: {
                KCoreVertexProgram.sendMessage(messenger, EMPTY_MESSAGE);
                break;
            }
            case 1: {
                KCoreVertexProgram.filterByDegree(vertex, messenger, memory, false);
                break;
            }
            default: {
                if (((Boolean)memory.get(PERSIST_CORENESS)).booleanValue() && vertex.property("kCoreVertexProgram.kCoreLabel").isPresent()) {
                    vertex.property(CORENESS, (Object)((Long)memory.get("kCoreVertexProgram.k") - 1L));
                    if ((Long)vertex.value("corenessVertexProgram.messageCount") < (Long)memory.get("kCoreVertexProgram.k")) {
                        vertex.property("kCoreVertexProgram.kCoreLabel").remove();
                        break;
                    }
                }
                if (KCoreVertexProgram.atRelationships(memory)) {
                    KCoreVertexProgram.relayOrSaveMessages(vertex, messenger);
                    break;
                }
                KCoreVertexProgram.updateEntityAndAttribute(vertex, messenger, memory, true);
            }
        }
    }

    public boolean terminate(Memory memory) {
        if (memory.isInitialIteration()) {
            LOGGER.debug("Finished Iteration " + memory.getIteration());
            return false;
        }
        if (memory.getIteration() == 200) {
            LOGGER.debug("Reached Max Iteration: 200 !!!!!!!!");
            throw GraqlQueryException.maxIterationsReached(this.getClass());
        }
        if (((Boolean)memory.get(PERSIST_CORENESS)).booleanValue()) {
            memory.set(PERSIST_CORENESS, (Object)false);
        }
        if (!KCoreVertexProgram.atRelationships(memory)) {
            LOGGER.debug("UpdateEntityAndAttribute... Finished Iteration " + memory.getIteration());
            if (!((Boolean)memory.get("kCoreVertexProgram.exist")).booleanValue()) {
                LOGGER.debug("KCoreVertexProgram Finished !!!!!!!!");
                return true;
            }
            if (((Boolean)memory.get("kCoreVertexProgram.stable")).booleanValue()) {
                LOGGER.debug("Found Core Areas K = " + memory.get("kCoreVertexProgram.k") + "\n");
                memory.set("kCoreVertexProgram.k", (Object)((Long)memory.get("kCoreVertexProgram.k") + 1L));
                memory.set(PERSIST_CORENESS, (Object)true);
            } else {
                memory.set("kCoreVertexProgram.stable", (Object)true);
            }
            memory.set("kCoreVertexProgram.exist", (Object)false);
            return false;
        }
        LOGGER.debug("RelayOrSaveMessage...       Finished Iteration " + memory.getIteration());
        return false;
    }
}

