/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.analytics;

import ai.grakn.concept.LabelId;
import ai.grakn.graql.internal.analytics.DegreeVertexProgram;
import ai.grakn.graql.internal.analytics.Utility;
import ai.grakn.util.CommonUtil;
import ai.grakn.util.Schema;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;
import org.apache.tinkerpop.gremlin.process.computer.Messenger;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class DegreeStatisticsVertexProgram
extends DegreeVertexProgram {
    public DegreeStatisticsVertexProgram() {
    }

    public DegreeStatisticsVertexProgram(Set<LabelId> ofLabelIDs) {
        super(ofLabelIDs);
    }

    @Override
    public void safeExecute(Vertex vertex, Messenger<Long> messenger, Memory memory) {
        switch (memory.getIteration()) {
            case 0: {
                DegreeStatisticsVertexProgram.degreeStatisticsStepResourceOwner(vertex, messenger, this.ofLabelIds);
                break;
            }
            case 1: {
                DegreeStatisticsVertexProgram.degreeStatisticsStepResourceRelation(vertex, messenger, this.ofLabelIds);
                break;
            }
            case 2: {
                DegreeStatisticsVertexProgram.degreeStatisticsStepResource(vertex, messenger, this.ofLabelIds);
                break;
            }
            default: {
                throw CommonUtil.unreachableStatement((String)"Exceeded expected maximum number of iterations");
            }
        }
    }

    @Override
    public Set<MessageScope> getMessageScopes(Memory memory) {
        switch (memory.getIteration()) {
            case 0: {
                return Sets.newHashSet((Object[])new MessageScope[]{messageScopeShortcutIn, messageScopeResourceOut});
            }
            case 1: {
                return Collections.singleton(messageScopeShortcutOut);
            }
        }
        return Collections.emptySet();
    }

    @Override
    public boolean terminate(Memory memory) {
        LOGGER.debug("Finished Degree Iteration " + memory.getIteration());
        return memory.getIteration() == 2;
    }

    static void degreeStatisticsStepResourceOwner(Vertex vertex, Messenger<Long> messenger, Set<LabelId> ofLabelIds) {
        LabelId labelId = Utility.getVertexTypeId(vertex);
        if (labelId.isValid() && !ofLabelIds.contains(labelId)) {
            messenger.sendMessage((MessageScope)messageScopeShortcutIn, (Object)1L);
            messenger.sendMessage((MessageScope)messageScopeResourceOut, (Object)1L);
        }
    }

    static void degreeStatisticsStepResourceRelation(Vertex vertex, Messenger<Long> messenger, Set<LabelId> ofLabelIds) {
        if (messenger.receiveMessages().hasNext()) {
            if (vertex.label().equals(Schema.BaseType.RELATIONSHIP.name())) {
                messenger.sendMessage((MessageScope)messageScopeOut, (Object)1L);
            } else if (ofLabelIds.contains(Utility.getVertexTypeId(vertex))) {
                vertex.property("degreeVertexProgram.degree", (Object)DegreeStatisticsVertexProgram.getMessageCount(messenger));
            }
        }
    }

    static void degreeStatisticsStepResource(Vertex vertex, Messenger<Long> messenger, Set<LabelId> ofLabelIds) {
        if (Utility.vertexHasSelectedTypeId(vertex, ofLabelIds)) {
            vertex.property("degreeVertexProgram.degree", (Object)(vertex.property("degreeVertexProgram.degree").isPresent() ? DegreeStatisticsVertexProgram.getMessageCount(messenger) + (Long)vertex.value("degreeVertexProgram.degree") : DegreeStatisticsVertexProgram.getMessageCount(messenger)));
        }
    }
}

