/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.analytics;

import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.internal.analytics.GraknVertexProgram;
import ai.grakn.graql.internal.analytics.NoResultException;
import ai.grakn.util.Schema;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.BinaryOperator;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.MemoryComputeKey;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;
import org.apache.tinkerpop.gremlin.process.computer.Messenger;
import org.apache.tinkerpop.gremlin.process.computer.VertexComputeKey;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.util.iterator.IteratorUtils;

public class KCoreVertexProgram
extends GraknVertexProgram<String> {
    private static final int MAX_ITERATION = 200;
    private static final String EMPTY_MESSAGE = "";
    public static final String K_CORE_LABEL = "kCoreVertexProgram.kCoreLabel";
    static final String IMPLICIT_MESSAGE_COUNT = "kCoreVertexProgram.implicitMessageCount";
    static final String MESSAGE_COUNT = "corenessVertexProgram.messageCount";
    static final String K_CORE_STABLE = "kCoreVertexProgram.stable";
    static final String K_CORE_EXIST = "kCoreVertexProgram.exist";
    static final String K = "kCoreVertexProgram.k";
    private static final String CONNECTED_COMPONENT_STARTED = "kCoreVertexProgram.ccStarted";
    private static final String VOTE_TO_HALT = "kCoreVertexProgram.voteToHalt";
    private static final Set<MemoryComputeKey> MEMORY_COMPUTE_KEYS = Sets.newHashSet((Object[])new MemoryComputeKey[]{MemoryComputeKey.of((String)"kCoreVertexProgram.stable", (BinaryOperator)Operator.and, (boolean)false, (boolean)true), MemoryComputeKey.of((String)"kCoreVertexProgram.exist", (BinaryOperator)Operator.or, (boolean)false, (boolean)true), MemoryComputeKey.of((String)"kCoreVertexProgram.ccStarted", (BinaryOperator)Operator.assign, (boolean)true, (boolean)true), MemoryComputeKey.of((String)"kCoreVertexProgram.voteToHalt", (BinaryOperator)Operator.and, (boolean)false, (boolean)true), MemoryComputeKey.of((String)"kCoreVertexProgram.k", (BinaryOperator)Operator.assign, (boolean)true, (boolean)true)});
    private static final Set<VertexComputeKey> VERTEX_COMPUTE_KEYS = Sets.newHashSet((Object[])new VertexComputeKey[]{VertexComputeKey.of((String)"kCoreVertexProgram.kCoreLabel", (boolean)false), VertexComputeKey.of((String)"kCoreVertexProgram.implicitMessageCount", (boolean)true)});

    public KCoreVertexProgram() {
    }

    public KCoreVertexProgram(long kValue) {
        this.persistentProperties.put(K, kValue);
    }

    public Set<VertexComputeKey> getVertexComputeKeys() {
        return VERTEX_COMPUTE_KEYS;
    }

    public Set<MemoryComputeKey> getMemoryComputeKeys() {
        return MEMORY_COMPUTE_KEYS;
    }

    @Override
    public void setup(Memory memory) {
        LOGGER.debug("KCoreVertexProgram Started !!!!!!!!");
        memory.set(K_CORE_STABLE, (Object)false);
        memory.set(K_CORE_EXIST, (Object)false);
        memory.set(K, this.persistentProperties.get(K));
        memory.set(VOTE_TO_HALT, (Object)true);
        memory.set(CONNECTED_COMPONENT_STARTED, (Object)false);
    }

    @Override
    public void safeExecute(Vertex vertex, Messenger<String> messenger, Memory memory) {
        switch (memory.getIteration()) {
            case 0: {
                KCoreVertexProgram.sendMessage(messenger, EMPTY_MESSAGE);
                break;
            }
            case 1: {
                KCoreVertexProgram.filterByDegree(vertex, messenger, memory, true);
                break;
            }
            default: {
                if (((Boolean)memory.get(CONNECTED_COMPONENT_STARTED)).booleanValue()) {
                    if (!messenger.receiveMessages().hasNext()) break;
                    if (vertex.property(K_CORE_LABEL).isPresent()) {
                        KCoreVertexProgram.updateClusterLabel(vertex, messenger, memory);
                        break;
                    }
                    if (!vertex.label().equals(Schema.BaseType.RELATIONSHIP.name())) break;
                    KCoreVertexProgram.relayClusterLabel(messenger, memory);
                    break;
                }
                if (KCoreVertexProgram.atRelationships(memory)) {
                    KCoreVertexProgram.relayOrSaveMessages(vertex, messenger);
                    break;
                }
                KCoreVertexProgram.updateEntityAndAttribute(vertex, messenger, memory, false);
            }
        }
    }

    static void filterByDegree(Vertex vertex, Messenger<String> messenger, Memory memory, boolean persistId) {
        if ((vertex.label().equals(Schema.BaseType.ENTITY.name()) || vertex.label().equals(Schema.BaseType.ATTRIBUTE.name())) && (long)Iterators.size((Iterator)messenger.receiveMessages()) >= (Long)memory.get(K)) {
            String id = (String)vertex.value(Schema.VertexProperty.ID.name());
            if (persistId) {
                vertex.property(K_CORE_LABEL, (Object)id);
            } else {
                vertex.property(K_CORE_LABEL, (Object)true);
            }
            memory.add(K_CORE_EXIST, (Object)true);
            KCoreVertexProgram.sendMessage(messenger, id);
        }
    }

    static void relayOrSaveMessages(Vertex vertex, Messenger<String> messenger) {
        if (messenger.receiveMessages().hasNext()) {
            if (vertex.label().equals(Schema.BaseType.RELATIONSHIP.name())) {
                messenger.receiveMessages().forEachRemaining(msg -> KCoreVertexProgram.sendMessage(messenger, msg));
            } else if ((vertex.label().equals(Schema.BaseType.ENTITY.name()) || vertex.label().equals(Schema.BaseType.ATTRIBUTE.name())) && vertex.property(K_CORE_LABEL).isPresent()) {
                vertex.property(IMPLICIT_MESSAGE_COUNT, (Object)Sets.newHashSet((Iterator)messenger.receiveMessages()).size());
            }
        }
    }

    static void updateEntityAndAttribute(Vertex vertex, Messenger<String> messenger, Memory memory, boolean persistMessageCount) {
        if (vertex.property(K_CORE_LABEL).isPresent()) {
            String id = (String)vertex.value(Schema.VertexProperty.ID.name());
            long messageCount = KCoreVertexProgram.getMessageCountExcludeSelf(messenger, id);
            if (vertex.property(IMPLICIT_MESSAGE_COUNT).isPresent()) {
                messageCount += ((Long)vertex.value(IMPLICIT_MESSAGE_COUNT)).longValue();
                vertex.property(IMPLICIT_MESSAGE_COUNT).remove();
            }
            if (messageCount >= (Long)memory.get(K)) {
                LOGGER.trace("Sending msg from " + id);
                KCoreVertexProgram.sendMessage(messenger, id);
                memory.add(K_CORE_EXIST, (Object)true);
                if (persistMessageCount) {
                    vertex.property(MESSAGE_COUNT, (Object)messageCount);
                }
            } else {
                LOGGER.trace("Removing label of " + id);
                vertex.property(K_CORE_LABEL).remove();
                memory.add(K_CORE_STABLE, (Object)false);
            }
        }
    }

    private static void updateClusterLabel(Vertex vertex, Messenger<String> messenger, Memory memory) {
        String currentMax = (String)vertex.value(K_CORE_LABEL);
        String max = (String)IteratorUtils.reduce((Iterator)messenger.receiveMessages(), (Object)currentMax, (a, b) -> a.compareTo((String)b) > 0 ? a : b);
        if (!max.equals(currentMax)) {
            LOGGER.trace("Cluster label of " + vertex + " changed from " + currentMax + " to " + max);
            vertex.property(K_CORE_LABEL, (Object)max);
            KCoreVertexProgram.sendMessage(messenger, max);
            memory.add(VOTE_TO_HALT, (Object)false);
        } else {
            LOGGER.trace("Cluster label of " + vertex + " is still " + currentMax);
        }
    }

    private static void relayClusterLabel(Messenger<String> messenger, Memory memory) {
        String firstMessage = (String)messenger.receiveMessages().next();
        String max = (String)IteratorUtils.reduce((Iterator)messenger.receiveMessages(), (Object)firstMessage, (a, b) -> a.compareTo((String)b) > 0 ? a : b);
        KCoreVertexProgram.sendMessage(messenger, max);
        memory.add(VOTE_TO_HALT, (Object)false);
    }

    private static int getMessageCountExcludeSelf(Messenger<String> messenger, String id) {
        HashSet messageSet = Sets.newHashSet((Iterator)messenger.receiveMessages());
        messageSet.remove(id);
        return messageSet.size();
    }

    static void sendMessage(Messenger<String> messenger, String message) {
        messenger.sendMessage((MessageScope)messageScopeIn, (Object)message);
        messenger.sendMessage((MessageScope)messageScopeOut, (Object)message);
    }

    static boolean atRelationships(Memory memory) {
        return memory.getIteration() % 2 == 0;
    }

    public boolean terminate(Memory memory) {
        LOGGER.debug("Finished Iteration " + memory.getIteration());
        if (memory.isInitialIteration()) {
            return false;
        }
        if (memory.getIteration() == 200) {
            LOGGER.debug("Reached Max Iteration: 200 !!!!!!!!");
            throw GraqlQueryException.maxIterationsReached(this.getClass());
        }
        if (((Boolean)memory.get(CONNECTED_COMPONENT_STARTED)).booleanValue()) {
            if (((Boolean)memory.get(VOTE_TO_HALT)).booleanValue()) {
                LOGGER.debug("KCoreVertexProgram Finished !!!!!!!!");
                return true;
            }
            memory.set(VOTE_TO_HALT, (Object)true);
            return false;
        }
        if (!KCoreVertexProgram.atRelationships(memory)) {
            if (!((Boolean)memory.get(K_CORE_EXIST)).booleanValue()) {
                LOGGER.debug("KCoreVertexProgram Finished !!!!!!!!");
                LOGGER.debug("No Such Core Areas Found !!!!!!!!");
                throw new NoResultException();
            }
            if (((Boolean)memory.get(K_CORE_STABLE)).booleanValue()) {
                memory.set(CONNECTED_COMPONENT_STARTED, (Object)true);
                LOGGER.debug("Found Core Areas !!!!!!!!");
                LOGGER.debug("Starting Connected Components !!!!!!!!");
            } else {
                memory.set(K_CORE_EXIST, (Object)false);
                memory.set(K_CORE_STABLE, (Object)true);
            }
            return false;
        }
        return false;
    }
}

