/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.analytics;

import ai.grakn.concept.ConceptId;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.internal.analytics.GraknVertexProgram;
import ai.grakn.graql.internal.analytics.NoResultException;
import ai.grakn.graql.internal.analytics.Utility;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BinaryOperator;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.MemoryComputeKey;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;
import org.apache.tinkerpop.gremlin.process.computer.Messenger;
import org.apache.tinkerpop.gremlin.process.computer.VertexComputeKey;
import org.apache.tinkerpop.gremlin.process.traversal.Operator;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class ShortestPathVertexProgram
extends GraknVertexProgram<PathMessage> {
    private static final int MAX_ITERATION = 50;
    private static final String PATH_HAS_MIDDLE_POINT = "shortestPathVertexProgram.pathHasMiddlePoint";
    private static final String PREDECESSOR = "shortestPathVertexProgram.fromVertex";
    private static final String VISITED_IN_ITERATION = "shortestPathVertexProgram.visitedInIteration";
    private static final String VOTE_TO_HALT_SOURCE = "shortestPathVertexProgram.voteToHalt.source";
    private static final String VOTE_TO_HALT_DESTINATION = "shortestPathVertexProgram.voteToHalt.destination";
    private static final String FOUND_PATH = "shortestPathVertexProgram.foundDestination";
    public static final String PREDECESSORS_FROM_SOURCE = "shortestPathVertexProgram.predecessors.fromSource";
    public static final String PREDECESSORS_FROM_DESTINATION = "shortestPathVertexProgram.predecessors.fromDestination";
    private static final String ITERATIONS_LEFT = "shortestPathVertexProgram.iterationsLeft";
    private static final String SOURCE = "shortestPathVertexProgram.source";
    private static final String DESTINATION = "shortestPathVertexProgram.destination";
    private static final Set<MemoryComputeKey> MEMORY_COMPUTE_KEYS = Sets.newHashSet((Object[])new MemoryComputeKey[]{MemoryComputeKey.of((String)"shortestPathVertexProgram.voteToHalt.source", (BinaryOperator)Operator.and, (boolean)false, (boolean)true), MemoryComputeKey.of((String)"shortestPathVertexProgram.voteToHalt.destination", (BinaryOperator)Operator.and, (boolean)false, (boolean)true), MemoryComputeKey.of((String)"shortestPathVertexProgram.foundDestination", (BinaryOperator)Operator.or, (boolean)true, (boolean)true), MemoryComputeKey.of((String)"shortestPathVertexProgram.predecessors.fromSource", (BinaryOperator)Operator.addAll, (boolean)false, (boolean)false), MemoryComputeKey.of((String)"shortestPathVertexProgram.predecessors.fromDestination", (BinaryOperator)Operator.addAll, (boolean)false, (boolean)false), MemoryComputeKey.of((String)"shortestPathVertexProgram.iterationsLeft", (BinaryOperator)Operator.assign, (boolean)true, (boolean)true), MemoryComputeKey.of((String)"shortestPathVertexProgram.pathHasMiddlePoint", (BinaryOperator)Operator.and, (boolean)false, (boolean)true)});

    public ShortestPathVertexProgram() {
    }

    public ShortestPathVertexProgram(ConceptId sourceId, ConceptId destinationId) {
        this.persistentProperties.put(SOURCE, sourceId.getValue());
        this.persistentProperties.put(DESTINATION, destinationId.getValue());
    }

    public Set<VertexComputeKey> getVertexComputeKeys() {
        return Sets.newHashSet((Object[])new VertexComputeKey[]{VertexComputeKey.of((String)PREDECESSOR, (boolean)true), VertexComputeKey.of((String)VISITED_IN_ITERATION, (boolean)true)});
    }

    public Set<MemoryComputeKey> getMemoryComputeKeys() {
        return MEMORY_COMPUTE_KEYS;
    }

    @Override
    public Set<MessageScope> getMessageScopes(Memory memory) {
        return messageScopeSetInAndOut;
    }

    @Override
    public void setup(Memory memory) {
        LOGGER.debug("ShortestPathVertexProgram Started !!!!!!!!");
        memory.set(VOTE_TO_HALT_SOURCE, (Object)true);
        memory.set(VOTE_TO_HALT_DESTINATION, (Object)true);
        memory.set(FOUND_PATH, (Object)false);
        memory.set(PATH_HAS_MIDDLE_POINT, (Object)true);
        memory.set(ITERATIONS_LEFT, (Object)-1);
        memory.set(PREDECESSORS_FROM_SOURCE, new HashMap());
        memory.set(PREDECESSORS_FROM_DESTINATION, new HashMap());
    }

    @Override
    public void safeExecute(Vertex vertex, Messenger<PathMessage> messenger, Memory memory) {
        if (memory.isInitialIteration()) {
            String id = Utility.getVertexId(vertex);
            if (this.persistentProperties.get(SOURCE).equals(id)) {
                LOGGER.debug("Found source vertex");
                vertex.property(VISITED_IN_ITERATION, (Object)1);
                ShortestPathVertexProgram.sendMessage(messenger, PathMessage.of(Direction.FROM_SOURCE, id));
            } else if (this.persistentProperties.get(DESTINATION).equals(id)) {
                LOGGER.debug("Found destination vertex");
                vertex.property(VISITED_IN_ITERATION, (Object)-1);
                ShortestPathVertexProgram.sendMessage(messenger, PathMessage.of(Direction.FROM_DESTINATION, id));
            }
        } else if (((Boolean)memory.get(FOUND_PATH)).booleanValue()) {
            if (messenger.receiveMessages().hasNext() && vertex.property(VISITED_IN_ITERATION).isPresent()) {
                ShortestPathVertexProgram.recordPredecessors(vertex, messenger, memory);
            }
        } else if (messenger.receiveMessages().hasNext()) {
            this.updateInstance(vertex, messenger, memory);
        }
    }

    private static void sendMessage(Messenger<PathMessage> messenger, PathMessage message) {
        messenger.sendMessage((MessageScope)messageScopeIn, (Object)message);
        messenger.sendMessage((MessageScope)messageScopeOut, (Object)message);
    }

    private static void recordPredecessors(Vertex vertex, Messenger<PathMessage> messenger, Memory memory) {
        Map<String, Set<String>> predecessorsMap;
        int iterationLeft;
        int visitedInIteration = (Integer)vertex.value(VISITED_IN_ITERATION);
        if (visitedInIteration == (iterationLeft = ((Integer)memory.get(ITERATIONS_LEFT)).intValue())) {
            Map<String, Set<String>> predecessorsMap2 = ShortestPathVertexProgram.getPredecessors(vertex, messenger);
            if (!predecessorsMap2.isEmpty()) {
                memory.add(PREDECESSORS_FROM_SOURCE, predecessorsMap2);
                ShortestPathVertexProgram.sendMessage(messenger, PathMessage.of(Direction.FROM_MIDDLE, Utility.getVertexId(vertex)));
            }
        } else if (-visitedInIteration == iterationLeft && !(predecessorsMap = ShortestPathVertexProgram.getPredecessors(vertex, messenger)).isEmpty()) {
            memory.add(PREDECESSORS_FROM_DESTINATION, predecessorsMap);
            ShortestPathVertexProgram.sendMessage(messenger, PathMessage.of(Direction.FROM_MIDDLE, Utility.getVertexId(vertex)));
        }
    }

    private static Map<String, Set<String>> getPredecessors(Vertex vertex, Messenger<PathMessage> messenger) {
        HashSet<String> predecessors = new HashSet<String>();
        Iterator iterator = messenger.receiveMessages();
        while (iterator.hasNext()) {
            PathMessage message = (PathMessage)iterator.next();
            if (message.direction() != Direction.FROM_MIDDLE) continue;
            predecessors.add(message.id());
        }
        if (predecessors.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Set<String>> predecessorMap = new HashMap<String, Set<String>>();
        predecessorMap.put(Utility.getVertexId(vertex), predecessors);
        return predecessorMap;
    }

    private void updateInstance(Vertex vertex, Messenger<PathMessage> messenger, Memory memory) {
        block5: {
            block6: {
                block4: {
                    if (vertex.property(VISITED_IN_ITERATION).isPresent()) break block4;
                    String id = Utility.getVertexId(vertex);
                    LOGGER.trace("Checking instance " + id);
                    boolean hasMessageSource = false;
                    boolean hasMessageDestination = false;
                    Iterator iterator = messenger.receiveMessages();
                    while (iterator.hasNext()) {
                        Direction messageDirection = ((PathMessage)iterator.next()).direction();
                        if (messageDirection == Direction.FROM_SOURCE) {
                            if (hasMessageSource) continue;
                            LOGGER.trace("Received a message from source vertex");
                            hasMessageSource = true;
                            vertex.property(VISITED_IN_ITERATION, (Object)(memory.getIteration() + 1));
                            memory.add(VOTE_TO_HALT_SOURCE, (Object)false);
                            if (!hasMessageDestination) continue;
                            LOGGER.trace("Found path(s)");
                            memory.add(FOUND_PATH, (Object)true);
                            continue;
                        }
                        if (hasMessageDestination) continue;
                        LOGGER.trace("Received a message from destination vertex");
                        hasMessageDestination = true;
                        vertex.property(VISITED_IN_ITERATION, (Object)(-memory.getIteration() - 1));
                        memory.add(VOTE_TO_HALT_DESTINATION, (Object)false);
                        if (!hasMessageSource) continue;
                        LOGGER.trace("Found path(s)");
                        memory.add(FOUND_PATH, (Object)true);
                    }
                    PathMessage message = hasMessageSource && hasMessageDestination ? PathMessage.of(Direction.FROM_MIDDLE, id) : PathMessage.of(hasMessageSource ? Direction.FROM_SOURCE : Direction.FROM_DESTINATION, id);
                    ShortestPathVertexProgram.sendMessage(messenger, message);
                    break block5;
                }
                if ((Integer)vertex.value(VISITED_IN_ITERATION) <= 0) break block6;
                Iterator iterator = messenger.receiveMessages();
                HashSet<String> middleLinkSet = new HashSet<String>();
                while (iterator.hasNext()) {
                    PathMessage message = (PathMessage)iterator.next();
                    if (message.direction() != Direction.FROM_DESTINATION) continue;
                    middleLinkSet.add(message.id());
                }
                if (middleLinkSet.isEmpty()) break block5;
                LOGGER.trace("Found path");
                memory.add(FOUND_PATH, (Object)true);
                memory.add(PATH_HAS_MIDDLE_POINT, (Object)false);
                String id = Utility.getVertexId(vertex);
                HashMap<String, HashSet<String>> middleLinkMap = new HashMap<String, HashSet<String>>();
                middleLinkMap.put(id, middleLinkSet);
                memory.add(PREDECESSORS_FROM_SOURCE, middleLinkMap);
                ShortestPathVertexProgram.sendMessage(messenger, PathMessage.of(Direction.FROM_MIDDLE, id));
                break block5;
            }
            Iterator iterator = messenger.receiveMessages();
            while (iterator.hasNext()) {
                PathMessage message = (PathMessage)iterator.next();
                if (message.direction() != Direction.FROM_SOURCE) continue;
                ShortestPathVertexProgram.sendMessage(messenger, PathMessage.of(Direction.FROM_MIDDLE, Utility.getVertexId(vertex)));
                break;
            }
        }
    }

    public boolean terminate(Memory memory) {
        LOGGER.debug("Finished Iteration " + memory.getIteration());
        if (memory.getIteration() == 0) {
            return false;
        }
        if (((Boolean)memory.get(FOUND_PATH)).booleanValue()) {
            if ((Integer)memory.get(ITERATIONS_LEFT) == -1) {
                if (!((Boolean)memory.get(PATH_HAS_MIDDLE_POINT)).booleanValue()) {
                    if (memory.getIteration() == 1) {
                        return true;
                    }
                    memory.set(ITERATIONS_LEFT, (Object)(memory.getIteration() - 1));
                } else {
                    memory.set(ITERATIONS_LEFT, (Object)memory.getIteration());
                }
                return false;
            }
            if ((Integer)memory.get(ITERATIONS_LEFT) == 1) {
                return true;
            }
            memory.set(ITERATIONS_LEFT, (Object)((Integer)memory.get(ITERATIONS_LEFT) - 1));
            return false;
        }
        if (((Boolean)memory.get(VOTE_TO_HALT_SOURCE)).booleanValue() || ((Boolean)memory.get(VOTE_TO_HALT_DESTINATION)).booleanValue()) {
            LOGGER.debug("There is no path between the given instances");
            throw new NoResultException();
        }
        if (memory.getIteration() == 50) {
            LOGGER.debug("Reached Max Iteration: 50 !!!!!!!!");
            throw GraqlQueryException.maxIterationsReached(this.getClass());
        }
        memory.set(VOTE_TO_HALT_SOURCE, (Object)true);
        memory.set(VOTE_TO_HALT_DESTINATION, (Object)true);
        return false;
    }

    static enum Direction {
        FROM_SOURCE,
        FROM_DESTINATION,
        FROM_MIDDLE;

    }

    static class PathMessage {
        private Direction direction;
        private String id;

        private PathMessage(Direction direction, String id) {
            this.direction = direction;
            this.id = id;
        }

        static PathMessage of(Direction direction, String id) {
            return new PathMessage(direction, id);
        }

        Direction direction() {
            return this.direction;
        }

        String id() {
            return this.id;
        }
    }
}

