/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.analytics;

import ai.grakn.GraknTx;
import ai.grakn.concept.Concept;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.LabelId;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.VarPattern;
import ai.grakn.util.Schema;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.KeyValue;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class Utility {
    static LabelId getVertexTypeId(Vertex vertex) {
        if (vertex.property(Schema.VertexProperty.THING_TYPE_LABEL_ID.name()).isPresent()) {
            return LabelId.of((Integer)((Integer)vertex.value(Schema.VertexProperty.THING_TYPE_LABEL_ID.name())));
        }
        return LabelId.invalid();
    }

    static boolean vertexHasSelectedTypeId(Vertex vertex, Set<LabelId> selectedTypeIds) {
        return vertex.property(Schema.VertexProperty.THING_TYPE_LABEL_ID.name()).isPresent() && selectedTypeIds.contains(LabelId.of((Integer)((Integer)vertex.value(Schema.VertexProperty.THING_TYPE_LABEL_ID.name()))));
    }

    static boolean isAlive(Vertex vertex) {
        if (vertex == null) {
            return false;
        }
        try {
            return vertex.property(Schema.VertexProperty.ID.name()).isPresent();
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    static <T> Set<T> reduceSet(Iterator<Set<T>> values) {
        HashSet set = new HashSet();
        while (values.hasNext()) {
            set.addAll(values.next());
        }
        return set;
    }

    static <K, V> Map<K, V> keyValuesToMap(Iterator<KeyValue<K, V>> keyValues) {
        HashMap map = new HashMap();
        keyValues.forEachRemaining(pair -> map.put(pair.getKey(), pair.getValue()));
        return map;
    }

    private static boolean mayHaveResourceEdge(GraknTx graknGraph, ConceptId conceptId1, ConceptId conceptId2) {
        Concept concept1 = graknGraph.getConcept(conceptId1);
        Concept concept2 = graknGraph.getConcept(conceptId2);
        return concept1 != null && concept2 != null && (concept1.isAttribute() || concept2.isAttribute());
    }

    public static ConceptId getResourceEdgeId(GraknTx graph, ConceptId conceptId1, ConceptId conceptId2) {
        Optional firstConcept;
        if (Utility.mayHaveResourceEdge(graph, conceptId1, conceptId2) && (firstConcept = graph.graql().match(new Pattern[]{Graql.var("x").id(conceptId1), Graql.var("y").id(conceptId2), Graql.var("z").rel((VarPattern)Graql.var("x")).rel((VarPattern)Graql.var("y"))}).get("z").findFirst()).isPresent()) {
            return ((Concept)firstConcept.get()).getId();
        }
        return null;
    }

    static String getVertexId(Vertex vertex) {
        return (String)vertex.value(Schema.VertexProperty.ID.name());
    }
}

