/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin;

import ai.grakn.GraknTx;
import ai.grakn.concept.ConceptId;
import ai.grakn.graql.Var;
import ai.grakn.graql.internal.gremlin.AutoValue_GraqlTraversal;
import ai.grakn.graql.internal.gremlin.fragment.Fragment;
import ai.grakn.util.CommonUtil;
import ai.grakn.util.Schema;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tinkerpop.gremlin.process.traversal.Step;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.SelectStep;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public abstract class GraqlTraversal {
    private static final long NUM_VERTICES_ESTIMATE = 10000L;
    private static final double COST_NEW_TRAVERSAL = Math.log1p(10000.0);

    static GraqlTraversal create(Set<? extends List<Fragment>> fragments) {
        ImmutableSet copy = (ImmutableSet)fragments.stream().map(ImmutableList::copyOf).collect(CommonUtil.toImmutableSet());
        return new AutoValue_GraqlTraversal((ImmutableSet<ImmutableList<Fragment>>)copy);
    }

    public GraphTraversal<Vertex, Map<String, Element>> getGraphTraversal(GraknTx graph, Set<Var> vars) {
        if (this.fragments().size() == 1) {
            ImmutableList list2 = (ImmutableList)Iterables.getOnlyElement(this.fragments());
            return this.getConjunctionTraversal(graph, (GraphTraversal<Vertex, Vertex>)graph.admin().getTinkerTraversal().V(new Object[0]), vars, (ImmutableList<Fragment>)list2);
        }
        Traversal[] traversals = (Traversal[])this.fragments().stream().map(list -> this.getConjunctionTraversal(graph, (GraphTraversal<Vertex, Vertex>)__.V((Object[])new Object[0]), vars, (ImmutableList<Fragment>)list)).toArray(Traversal[]::new);
        GraphTraversal traversal = graph.admin().getTinkerTraversal().V(new Object[0]).limit(1L).union(traversals);
        return GraqlTraversal.selectVars(traversal, vars);
    }

    public abstract ImmutableSet<ImmutableList<Fragment>> fragments();

    public GraqlTraversal transform(Map<Var, ConceptId> transform) {
        ImmutableList fragments = ImmutableList.copyOf((Collection)((ImmutableList)Iterables.getOnlyElement(this.fragments())).stream().map(f -> f.transform(transform)).collect(Collectors.toList()));
        return new AutoValue_GraqlTraversal((ImmutableSet<ImmutableList<Fragment>>)ImmutableSet.of((Object)fragments));
    }

    private GraphTraversal<Vertex, Map<String, Element>> getConjunctionTraversal(GraknTx graph, GraphTraversal<Vertex, Vertex> traversal, Set<Var> vars, ImmutableList<Fragment> fragmentList) {
        GraphTraversal newTraversal = traversal;
        if (((Fragment)fragmentList.get(0)).canOperateOnEdges()) {
            newTraversal = traversal.union(new Traversal[]{__.identity(), __.outE((String[])new String[]{Schema.EdgeLabel.ATTRIBUTE.getLabel()})});
        }
        return this.applyFragments(graph, vars, fragmentList, newTraversal);
    }

    private GraphTraversal<Vertex, Map<String, Element>> applyFragments(GraknTx graph, Set<Var> vars, ImmutableList<Fragment> fragmentList, GraphTraversal<Vertex, ? extends Element> traversal) {
        HashSet<Var> foundVars = new HashSet<Var>();
        Var currentName = null;
        for (Fragment fragment : fragmentList) {
            fragment.applyTraversal(traversal, graph, foundVars, currentName);
            currentName = fragment.end() != null ? fragment.end() : fragment.start();
        }
        return GraqlTraversal.selectVars(traversal, (Set<Var>)Sets.intersection(vars, foundVars));
    }

    public double getComplexity() {
        double totalCost = 0.0;
        for (List list : this.fragments()) {
            totalCost += GraqlTraversal.fragmentListCost(list);
        }
        return totalCost;
    }

    static double fragmentListCost(List<Fragment> fragments) {
        HashSet<Var> names = new HashSet<Var>();
        double listCost = 0.0;
        for (Fragment fragment : fragments) {
            listCost += GraqlTraversal.fragmentCost(fragment, names);
            names.addAll(fragment.vars());
        }
        return listCost;
    }

    static double fragmentCost(Fragment fragment, Collection<Var> names) {
        if (names.contains(fragment.start()) || fragment.hasFixedFragmentCost()) {
            return fragment.fragmentCost();
        }
        return COST_NEW_TRAVERSAL;
    }

    private static <S, E> GraphTraversal<S, Map<String, E>> selectVars(GraphTraversal<S, ?> traversal, Set<Var> vars) {
        if (vars.isEmpty()) {
            return traversal.constant((Object)ImmutableMap.of());
        }
        if (vars.size() == 1) {
            String label = vars.iterator().next().name();
            return traversal.select(label, label, new String[0]);
        }
        String[] labelArray = (String[])vars.stream().map(Var::name).toArray(String[]::new);
        return traversal.asAdmin().addStep((Step)new SelectStep((Traversal.Admin)traversal.asAdmin(), null, labelArray));
    }

    public String toString() {
        return "{" + this.fragments().stream().map(list -> {
            StringBuilder sb = new StringBuilder();
            Var currentName = null;
            for (Fragment fragment : list) {
                if (!fragment.start().equals(currentName)) {
                    if (currentName != null) {
                        sb.append(" ");
                    }
                    sb.append(fragment.start().shortName());
                    currentName = fragment.start();
                }
                sb.append(fragment.name());
                Var end = fragment.end();
                if (end == null) continue;
                sb.append(end.shortName());
                currentName = end;
            }
            return sb.toString();
        }).collect(Collectors.joining(", ")) + "}";
    }
}

