/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin.fragment;

import ai.grakn.concept.AttributeType;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Label;
import ai.grakn.graql.Graql;
import ai.grakn.graql.ValuePredicate;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.VarProperty;
import ai.grakn.graql.internal.gremlin.fragment.AutoValue_AttributeIndexFragment;
import ai.grakn.graql.internal.gremlin.fragment.AutoValue_DataTypeFragment;
import ai.grakn.graql.internal.gremlin.fragment.AutoValue_IdFragment;
import ai.grakn.graql.internal.gremlin.fragment.AutoValue_InIsaFragment;
import ai.grakn.graql.internal.gremlin.fragment.AutoValue_InPlaysFragment;
import ai.grakn.graql.internal.gremlin.fragment.AutoValue_InRelatesFragment;
import ai.grakn.graql.internal.gremlin.fragment.AutoValue_InRolePlayerFragment;
import ai.grakn.graql.internal.gremlin.fragment.AutoValue_InSubFragment;
import ai.grakn.graql.internal.gremlin.fragment.AutoValue_IsAbstractFragment;
import ai.grakn.graql.internal.gremlin.fragment.AutoValue_LabelFragment;
import ai.grakn.graql.internal.gremlin.fragment.AutoValue_NeqFragment;
import ai.grakn.graql.internal.gremlin.fragment.AutoValue_NotInternalFragment;
import ai.grakn.graql.internal.gremlin.fragment.AutoValue_OutIsaFragment;
import ai.grakn.graql.internal.gremlin.fragment.AutoValue_OutPlaysFragment;
import ai.grakn.graql.internal.gremlin.fragment.AutoValue_OutRelatesFragment;
import ai.grakn.graql.internal.gremlin.fragment.AutoValue_OutRolePlayerFragment;
import ai.grakn.graql.internal.gremlin.fragment.AutoValue_OutSubFragment;
import ai.grakn.graql.internal.gremlin.fragment.AutoValue_RegexFragment;
import ai.grakn.graql.internal.gremlin.fragment.AutoValue_ValueFragment;
import ai.grakn.graql.internal.gremlin.fragment.Fragment;
import ai.grakn.graql.internal.gremlin.fragment.InRelatesFragment;
import ai.grakn.graql.internal.util.StringConverter;
import ai.grakn.util.Schema;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.tinkerpop.gremlin.process.traversal.P;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.__;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;

public class Fragments {
    private Fragments() {
    }

    public static Fragment inRolePlayer(VarProperty varProperty, Var rolePlayer, Var edge, Var relation, @Nullable Var role, @Nullable ImmutableSet<Label> roleLabels, @Nullable ImmutableSet<Label> relationTypeLabels) {
        return new AutoValue_InRolePlayerFragment(varProperty, rolePlayer, relation, edge, role, roleLabels, relationTypeLabels);
    }

    public static Fragment outRolePlayer(VarProperty varProperty, Var relation, Var edge, Var rolePlayer, @Nullable Var role, @Nullable ImmutableSet<Label> roleLabels, @Nullable ImmutableSet<Label> relationTypeLabels) {
        return new AutoValue_OutRolePlayerFragment(varProperty, relation, rolePlayer, edge, role, roleLabels, relationTypeLabels);
    }

    public static Fragment inSub(VarProperty varProperty, Var start, Var end) {
        return new AutoValue_InSubFragment(varProperty, start, end);
    }

    public static Fragment outSub(VarProperty varProperty, Var start, Var end) {
        return new AutoValue_OutSubFragment(varProperty, start, end);
    }

    public static InRelatesFragment inRelates(VarProperty varProperty, Var start, Var end) {
        return new AutoValue_InRelatesFragment(varProperty, start, end);
    }

    public static Fragment outRelates(VarProperty varProperty, Var start, Var end) {
        return new AutoValue_OutRelatesFragment(varProperty, start, end);
    }

    public static Fragment inIsa(VarProperty varProperty, Var start, Var end, boolean mayHaveEdgeInstances) {
        return new AutoValue_InIsaFragment(varProperty, start, end, mayHaveEdgeInstances);
    }

    public static Fragment outIsa(VarProperty varProperty, Var start, Var end) {
        return new AutoValue_OutIsaFragment(varProperty, start, end);
    }

    public static Fragment dataType(VarProperty varProperty, Var start, AttributeType.DataType dataType) {
        return new AutoValue_DataTypeFragment(varProperty, start, dataType);
    }

    public static Fragment inPlays(VarProperty varProperty, Var start, Var end, boolean required) {
        return new AutoValue_InPlaysFragment(varProperty, start, end, required);
    }

    public static Fragment outPlays(VarProperty varProperty, Var start, Var end, boolean required) {
        return new AutoValue_OutPlaysFragment(varProperty, start, end, required);
    }

    public static Fragment id(VarProperty varProperty, Var start, ConceptId id) {
        return new AutoValue_IdFragment(varProperty, start, id);
    }

    public static Fragment label(VarProperty varProperty, Var start, ImmutableSet<Label> labels) {
        return new AutoValue_LabelFragment(varProperty, start, labels);
    }

    public static Fragment value(VarProperty varProperty, Var start, ValuePredicate predicate) {
        return new AutoValue_ValueFragment(varProperty, start, predicate);
    }

    public static Fragment isAbstract(VarProperty varProperty, Var start) {
        return new AutoValue_IsAbstractFragment(varProperty, start);
    }

    public static Fragment regex(VarProperty varProperty, Var start, String regex) {
        return new AutoValue_RegexFragment(varProperty, start, regex);
    }

    public static Fragment notInternal(VarProperty varProperty, Var start) {
        return new AutoValue_NotInternalFragment(varProperty, start);
    }

    public static Fragment neq(VarProperty varProperty, Var start, Var other) {
        return new AutoValue_NeqFragment(varProperty, start, other);
    }

    public static Fragment attributeIndex(@Nullable VarProperty varProperty, Var start, Label label, Object attributeValue) {
        String attributeIndex = Schema.generateAttributeIndex((Label)label, (String)attributeValue.toString());
        return new AutoValue_AttributeIndexFragment(varProperty, start, attributeIndex);
    }

    static <T> GraphTraversal<T, Vertex> outSubs(GraphTraversal<T, Vertex> traversal) {
        return Fragments.union(traversal, ImmutableSet.of((Object)__.not((Traversal)__.has((String)Schema.VertexProperty.THING_TYPE_LABEL_ID.name())).not((Traversal)__.hasLabel((String)Schema.BaseType.SHARD.name(), (String[])new String[0])), (Object)__.repeat((Traversal)__.out((String[])new String[]{Schema.EdgeLabel.SUB.getLabel()})).emit())).unfold();
    }

    static <T> GraphTraversal<T, Vertex> inSubs(GraphTraversal<T, Vertex> traversal) {
        return Fragments.union(traversal, ImmutableSet.of((Object)__.not((Traversal)__.has((String)Schema.VertexProperty.THING_TYPE_LABEL_ID.name())).not((Traversal)__.hasLabel((String)Schema.BaseType.SHARD.name(), (String[])new String[0])), (Object)__.repeat((Traversal)__.in((String[])new String[]{Schema.EdgeLabel.SUB.getLabel()})).emit())).unfold();
    }

    static <S, E> GraphTraversal<S, E> union(Iterable<GraphTraversal<? super S, ? extends E>> traversals) {
        return Fragments.union(__.identity(), traversals);
    }

    static <S, E1, E2> GraphTraversal<S, E2> union(GraphTraversal<S, ? extends E1> start, Iterable<GraphTraversal<? super E1, ? extends E2>> traversals) {
        GraphTraversal[] array = (GraphTraversal[])Iterables.toArray(traversals, GraphTraversal.class);
        return start.union((Traversal[])array);
    }

    static <T> GraphTraversal<T, Vertex> isVertex(GraphTraversal<T, ? extends Element> traversal) {
        return traversal.has(Schema.VertexProperty.ID.name());
    }

    static <T> GraphTraversal<T, Edge> isEdge(GraphTraversal<T, ? extends Element> traversal) {
        return traversal.hasNot(Schema.VertexProperty.ID.name());
    }

    static String displayOptionalTypeLabels(String name, @Nullable Set<Label> typeLabels) {
        if (typeLabels != null) {
            return " " + name + ":" + typeLabels.stream().map(StringConverter::typeLabelToString).collect(Collectors.joining(","));
        }
        return "";
    }

    static <S> GraphTraversal<S, Vertex> traverseSchemaConceptFromEdge(GraphTraversal<S, Edge> traversal, Schema.EdgeProperty edgeProperty) {
        Var labelId = Graql.var();
        traversal.values(new String[]{edgeProperty.name()}).as(labelId.name(), new String[0]);
        return traversal.V(new Object[0]).has(Schema.VertexProperty.LABEL_ID.name(), (Traversal)__.where((P)P.eq((Object)labelId.name())));
    }
}

