/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin.sets;

import ai.grakn.concept.Label;
import ai.grakn.graql.ValuePredicate;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.VarProperty;
import ai.grakn.graql.internal.gremlin.EquivalentFragmentSet;
import ai.grakn.graql.internal.gremlin.fragment.Fragment;
import ai.grakn.graql.internal.gremlin.fragment.Fragments;
import ai.grakn.graql.internal.gremlin.sets.AutoValue_AttributeIndexFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.EquivalentFragmentSets;
import ai.grakn.graql.internal.gremlin.sets.FragmentSetOptimisation;
import ai.grakn.graql.internal.gremlin.sets.IsaFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.LabelFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.ValueFragmentSet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;

abstract class AttributeIndexFragmentSet
extends EquivalentFragmentSet {
    static final FragmentSetOptimisation ATTRIBUTE_INDEX_OPTIMISATION = (fragmentSets, graph) -> {
        Iterable valueSets = AttributeIndexFragmentSet.equalsValueFragments(fragmentSets)::iterator;
        for (ValueFragmentSet valueSet : valueSets) {
            ImmutableSet<Label> labels;
            Var type;
            LabelFragmentSet nameSet;
            Var attribute = valueSet.var();
            IsaFragmentSet isaSet = EquivalentFragmentSets.typeInformationOf(attribute, fragmentSets);
            if (isaSet == null || (nameSet = EquivalentFragmentSets.labelOf(type = isaSet.type(), fragmentSets)) == null || (labels = nameSet.labels()).size() != 1) continue;
            Label label = (Label)Iterables.getOnlyElement(labels);
            AttributeIndexFragmentSet.optimise(fragmentSets, valueSet, isaSet, label);
            return true;
        }
        return false;
    };

    AttributeIndexFragmentSet() {
    }

    static AttributeIndexFragmentSet of(Var var, Label label, Object value) {
        return new AutoValue_AttributeIndexFragmentSet(var, label, value);
    }

    @Override
    @Nullable
    public final VarProperty varProperty() {
        return null;
    }

    @Override
    public final Set<Fragment> fragments() {
        return ImmutableSet.of((Object)Fragments.attributeIndex(this.varProperty(), this.var(), this.label(), this.value()));
    }

    abstract Var var();

    abstract Label label();

    abstract Object value();

    private static void optimise(Collection<EquivalentFragmentSet> fragmentSets, ValueFragmentSet valueSet, IsaFragmentSet isaSet, Label label) {
        fragmentSets.remove(valueSet);
        fragmentSets.remove(isaSet);
        Var attribute = valueSet.var();
        Object value = valueSet.predicate().equalsValue().get();
        AttributeIndexFragmentSet indexFragmentSet = AttributeIndexFragmentSet.of(attribute, label, value);
        fragmentSets.add(indexFragmentSet);
    }

    private static Stream<ValueFragmentSet> equalsValueFragments(Collection<EquivalentFragmentSet> fragmentSets) {
        return EquivalentFragmentSets.fragmentSetOfType(ValueFragmentSet.class, fragmentSets).filter(valueFragmentSet -> {
            ValuePredicate predicate = valueFragmentSet.predicate();
            return predicate.equalsValue().isPresent() && !predicate.getInnerVar().isPresent();
        });
    }
}

