/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin.sets;

import ai.grakn.GraknTx;
import ai.grakn.concept.AttributeType;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Label;
import ai.grakn.graql.ValuePredicate;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.VarProperty;
import ai.grakn.graql.internal.gremlin.EquivalentFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.AttributeIndexFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.AutoValue_DataTypeFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.AutoValue_IdFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.AutoValue_IsAbstractFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.AutoValue_IsaFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.AutoValue_LabelFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.AutoValue_NeqFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.AutoValue_NotInternalFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.AutoValue_PlaysFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.AutoValue_RegexFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.AutoValue_RelatesFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.AutoValue_RolePlayerFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.AutoValue_SubFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.AutoValue_ValueFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.FragmentSetOptimisation;
import ai.grakn.graql.internal.gremlin.sets.IsaFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.LabelFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.RolePlayerFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.SubFragmentSet;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class EquivalentFragmentSets {
    private static final ImmutableCollection<FragmentSetOptimisation> OPTIMISATIONS = ImmutableSet.of((Object)RolePlayerFragmentSet.ROLE_OPTIMISATION, (Object)AttributeIndexFragmentSet.ATTRIBUTE_INDEX_OPTIMISATION, (Object)RolePlayerFragmentSet.RELATION_TYPE_OPTIMISATION, (Object)LabelFragmentSet.REDUNDANT_LABEL_ELIMINATION_OPTIMISATION, (Object)SubFragmentSet.SUB_TRAVERSAL_ELIMINATION_OPTIMISATION, (Object)IsaFragmentSet.SKIP_EDGE_INSTANCE_CHECK_OPTIMISATION, (Object[])new FragmentSetOptimisation[0]);

    public static EquivalentFragmentSet plays(VarProperty varProperty, Var type, Var role, boolean required) {
        return new AutoValue_PlaysFragmentSet(varProperty, type, role, required);
    }

    public static EquivalentFragmentSet rolePlayer(VarProperty varProperty, Var relation, Var edge, Var rolePlayer, @Nullable Var role) {
        return new AutoValue_RolePlayerFragmentSet(varProperty, relation, edge, rolePlayer, role, null, null);
    }

    public static EquivalentFragmentSet sub(VarProperty varProperty, Var subType, Var superType) {
        return new AutoValue_SubFragmentSet(varProperty, subType, superType);
    }

    public static EquivalentFragmentSet relates(VarProperty varProperty, Var relationType, Var role) {
        return new AutoValue_RelatesFragmentSet(varProperty, relationType, role);
    }

    public static EquivalentFragmentSet notInternalFragmentSet(VarProperty varProperty, Var start) {
        return new AutoValue_NotInternalFragmentSet(varProperty, start);
    }

    public static EquivalentFragmentSet isa(VarProperty varProperty, Var instance, Var type, boolean mayHaveEdgeInstances) {
        return new AutoValue_IsaFragmentSet(varProperty, instance, type, mayHaveEdgeInstances);
    }

    public static EquivalentFragmentSet neq(VarProperty varProperty, Var varA, Var varB) {
        return new AutoValue_NeqFragmentSet(varProperty, varA, varB);
    }

    public static EquivalentFragmentSet value(VarProperty varProperty, Var resource, ValuePredicate predicate) {
        return new AutoValue_ValueFragmentSet(varProperty, resource, predicate);
    }

    public static EquivalentFragmentSet id(VarProperty varProperty, Var start, ConceptId id) {
        return new AutoValue_IdFragmentSet(varProperty, start, id);
    }

    public static EquivalentFragmentSet isAbstract(VarProperty varProperty, Var start) {
        return new AutoValue_IsAbstractFragmentSet(varProperty, start);
    }

    public static EquivalentFragmentSet label(VarProperty varProperty, Var type, ImmutableSet<Label> labels) {
        return new AutoValue_LabelFragmentSet(varProperty, type, labels);
    }

    public static EquivalentFragmentSet dataType(VarProperty varProperty, Var resourceType, AttributeType.DataType<?> dataType) {
        return new AutoValue_DataTypeFragmentSet(varProperty, resourceType, dataType);
    }

    public static EquivalentFragmentSet regex(VarProperty varProperty, Var resourceType, String regex) {
        return new AutoValue_RegexFragmentSet(varProperty, resourceType, regex);
    }

    public static void optimiseFragmentSets(Collection<EquivalentFragmentSet> fragmentSets, GraknTx graph) {
        boolean changed = true;
        while (changed) {
            changed = false;
            for (FragmentSetOptimisation optimisation : OPTIMISATIONS) {
                changed |= optimisation.apply(fragmentSets, graph);
            }
        }
    }

    static <T extends EquivalentFragmentSet> Stream<T> fragmentSetOfType(Class<T> clazz, Collection<EquivalentFragmentSet> fragmentSets) {
        return fragmentSets.stream().filter(clazz::isInstance).map(clazz::cast);
    }

    @Nullable
    static LabelFragmentSet labelOf(Var type, Collection<EquivalentFragmentSet> fragmentSets) {
        return EquivalentFragmentSets.fragmentSetOfType(LabelFragmentSet.class, fragmentSets).filter(labelFragmentSet -> labelFragmentSet.var().equals((Object)type)).findAny().orElse(null);
    }

    @Nullable
    static IsaFragmentSet typeInformationOf(Var instance, Collection<EquivalentFragmentSet> fragmentSets) {
        return EquivalentFragmentSets.fragmentSetOfType(IsaFragmentSet.class, fragmentSets).filter(isaFragmentSet -> isaFragmentSet.instance().equals((Object)instance)).findAny().orElse(null);
    }
}

