/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin.sets;

import ai.grakn.GraknTx;
import ai.grakn.concept.Concept;
import ai.grakn.concept.Label;
import ai.grakn.concept.Role;
import ai.grakn.concept.SchemaConcept;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.VarProperty;
import ai.grakn.graql.internal.gremlin.EquivalentFragmentSet;
import ai.grakn.graql.internal.gremlin.fragment.Fragment;
import ai.grakn.graql.internal.gremlin.fragment.Fragments;
import ai.grakn.graql.internal.gremlin.sets.AutoValue_RolePlayerFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.EquivalentFragmentSets;
import ai.grakn.graql.internal.gremlin.sets.FragmentSetOptimisation;
import ai.grakn.graql.internal.gremlin.sets.IsaFragmentSet;
import ai.grakn.graql.internal.gremlin.sets.LabelFragmentSet;
import ai.grakn.util.CommonUtil;
import ai.grakn.util.Schema;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

abstract class RolePlayerFragmentSet
extends EquivalentFragmentSet {
    static final FragmentSetOptimisation ROLE_OPTIMISATION = (fragmentSets, tx) -> {
        Iterable rolePlayers = EquivalentFragmentSets.fragmentSetOfType(RolePlayerFragmentSet.class, fragmentSets)::iterator;
        for (RolePlayerFragmentSet rolePlayer : rolePlayers) {
            LabelFragmentSet roleLabel;
            Var roleVar = rolePlayer.role();
            if (roleVar == null || (roleLabel = EquivalentFragmentSets.labelOf(roleVar, fragmentSets)) == null) continue;
            RolePlayerFragmentSet newRolePlayer = null;
            if (roleLabel.labels().equals((Object)ImmutableSet.of((Object)Schema.MetaSchema.ROLE.getLabel()))) {
                newRolePlayer = rolePlayer.removeRoleVar();
            } else {
                Set concepts = roleLabel.labels().stream().map(arg_0 -> ((GraknTx)tx).getSchemaConcept(arg_0)).collect(Collectors.toSet());
                if (concepts.stream().allMatch(schemaConcept -> schemaConcept != null && schemaConcept.isRole())) {
                    Stream<Role> roles = concepts.stream().map(Concept::asRole);
                    newRolePlayer = rolePlayer.substituteRoleLabel(roles);
                }
            }
            if (newRolePlayer == null) continue;
            fragmentSets.remove(rolePlayer);
            fragmentSets.add(newRolePlayer);
            return true;
        }
        return false;
    };
    static final FragmentSetOptimisation RELATION_TYPE_OPTIMISATION = (fragmentSets, graph) -> {
        Iterable rolePlayers = EquivalentFragmentSets.fragmentSetOfType(RolePlayerFragmentSet.class, fragmentSets)::iterator;
        for (RolePlayerFragmentSet rolePlayer : rolePlayers) {
            Stream<SchemaConcept> concepts;
            LabelFragmentSet relationLabel;
            IsaFragmentSet isa;
            if (rolePlayer.relationshipTypeLabels() != null || (isa = EquivalentFragmentSets.typeInformationOf(rolePlayer.relation(), fragmentSets)) == null || (relationLabel = EquivalentFragmentSets.labelOf(isa.type(), fragmentSets)) == null || !(concepts = relationLabel.labels().stream().map(arg_0 -> ((GraknTx)graph).getSchemaConcept(arg_0))).allMatch(schemaConcept -> schemaConcept != null && schemaConcept.isRelationshipType())) continue;
            fragmentSets.remove(rolePlayer);
            fragmentSets.add(rolePlayer.addRelationshipTypeLabels(relationLabel.labels()));
            return true;
        }
        return false;
    };

    RolePlayerFragmentSet() {
    }

    public static RolePlayerFragmentSet of(VarProperty varProperty, Var relation, Var edge, Var rolePlayer, @Nullable Var role, @Nullable ImmutableSet<Label> roleLabels, @Nullable ImmutableSet<Label> relationTypeLabels) {
        return new AutoValue_RolePlayerFragmentSet(varProperty, relation, edge, rolePlayer, role, roleLabels, relationTypeLabels);
    }

    @Override
    public final Set<Fragment> fragments() {
        return ImmutableSet.of((Object)Fragments.inRolePlayer(this.varProperty(), this.rolePlayer(), this.edge(), this.relation(), this.role(), this.roleLabels(), this.relationshipTypeLabels()), (Object)Fragments.outRolePlayer(this.varProperty(), this.relation(), this.edge(), this.rolePlayer(), this.role(), this.roleLabels(), this.relationshipTypeLabels()));
    }

    abstract Var relation();

    abstract Var edge();

    abstract Var rolePlayer();

    @Nullable
    abstract Var role();

    @Nullable
    abstract ImmutableSet<Label> roleLabels();

    @Nullable
    abstract ImmutableSet<Label> relationshipTypeLabels();

    private RolePlayerFragmentSet substituteRoleLabel(Stream<Role> roles) {
        Preconditions.checkNotNull((Object)this.role());
        Preconditions.checkState((this.roleLabels() == null ? 1 : 0) != 0);
        ImmutableSet newRoleLabels = (ImmutableSet)roles.flatMap(Role::subs).map(SchemaConcept::getLabel).collect(CommonUtil.toImmutableSet());
        return new AutoValue_RolePlayerFragmentSet(this.varProperty(), this.relation(), this.edge(), this.rolePlayer(), null, (ImmutableSet<Label>)newRoleLabels, this.relationshipTypeLabels());
    }

    private RolePlayerFragmentSet addRelationshipTypeLabels(ImmutableSet<Label> relTypeLabels) {
        Preconditions.checkState((this.relationshipTypeLabels() == null ? 1 : 0) != 0);
        return new AutoValue_RolePlayerFragmentSet(this.varProperty(), this.relation(), this.edge(), this.rolePlayer(), this.role(), this.roleLabels(), relTypeLabels);
    }

    private RolePlayerFragmentSet removeRoleVar() {
        Preconditions.checkNotNull((Object)this.role());
        return new AutoValue_RolePlayerFragmentSet(this.varProperty(), this.relation(), this.edge(), this.rolePlayer(), null, this.roleLabels(), this.relationshipTypeLabels());
    }
}

