/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin.spanningtree;

import ai.grakn.graql.internal.gremlin.spanningtree.graph.DirectedEdge;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;

public class Arborescence<V> {
    private final ImmutableMap<V, V> parents;
    private final V root;

    private Arborescence(ImmutableMap<V, V> parents, V root) {
        this.parents = parents;
        this.root = root;
    }

    public static <T> Arborescence<T> of(ImmutableMap<T, T> parents) {
        if (parents != null && !parents.isEmpty()) {
            HashSet allParents = Sets.newHashSet((Iterable)parents.values());
            allParents.removeAll((Collection<?>)parents.keySet());
            if (allParents.size() == 1) {
                return new Arborescence<T>(parents, allParents.iterator().next());
            }
        }
        return new Arborescence<Object>(parents, null);
    }

    public static <T> Arborescence<T> empty() {
        return Arborescence.of(ImmutableMap.of());
    }

    public boolean contains(DirectedEdge<V> e) {
        Object dest = e.destination;
        return this.parents.containsKey(dest) && this.parents.get(dest).equals(e.source);
    }

    public V getRoot() {
        return this.root;
    }

    public ImmutableMap<V, V> getParents() {
        return this.parents;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.parents.forEach((key, value) -> stringBuilder.append(value).append(" -> ").append(key).append("; "));
        return stringBuilder.toString();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Arborescence that = (Arborescence)other;
        ImmutableSet myEntries = this.parents.entrySet();
        ImmutableSet thatEntries = that.parents.entrySet();
        return myEntries.size() == thatEntries.size() && myEntries.containsAll((Collection<?>)thatEntries);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.parents});
    }
}

