/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin.spanningtree;

import ai.grakn.graql.internal.gremlin.spanningtree.Arborescence;
import ai.grakn.graql.internal.gremlin.spanningtree.EdgeQueueMap;
import ai.grakn.graql.internal.gremlin.spanningtree.ExclusiveEdge;
import ai.grakn.graql.internal.gremlin.spanningtree.graph.DirectedEdge;
import ai.grakn.graql.internal.gremlin.spanningtree.graph.WeightedGraph;
import ai.grakn.graql.internal.gremlin.spanningtree.util.Weighted;
import ai.grakn.graql.internal.util.Partition;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class ChuLiuEdmonds {
    public static <V> Weighted<Arborescence<V>> getMaxArborescence(WeightedGraph<V> graph, V root) {
        return ChuLiuEdmonds.getMaxArborescence(graph.filterEdges(Predicates.not(DirectedEdge.hasDestination(root))));
    }

    static <V> Weighted<Arborescence<V>> getMaxArborescence(WeightedGraph<V> graph, Set<DirectedEdge<V>> required, Set<DirectedEdge<V>> banned) {
        return ChuLiuEdmonds.getMaxArborescence(graph.filterEdges(Predicates.and((Predicate)Predicates.not(DirectedEdge.competesWith(required)), (Predicate)Predicates.not(DirectedEdge.isIn(banned)))));
    }

    public static <V> Weighted<Arborescence<V>> getMaxArborescence(WeightedGraph<V> graph) {
        PartialSolution<Object> partialSolution = PartialSolution.initialize(graph.filterEdges(Predicates.not(DirectedEdge.isAutoCycle())));
        ArrayDeque<V> componentsWithNoInEdges = new ArrayDeque<V>(partialSolution.getNodes());
        while (!componentsWithNoInEdges.isEmpty()) {
            ExclusiveEdge<V> maxInEdge;
            Optional<V> newComponent;
            Object component = componentsWithNoInEdges.poll();
            Optional<ExclusiveEdge<V>> oMaxInEdge = partialSolution.popBestEdge(component);
            if (!oMaxInEdge.isPresent() || !(newComponent = partialSolution.addEdge(maxInEdge = oMaxInEdge.get())).isPresent()) continue;
            componentsWithNoInEdges.add(newComponent.get());
        }
        return ((PartialSolution)partialSolution).recoverBestArborescence();
    }

    static class PartialSolution<V> {
        private final Partition<V> stronglyConnected;
        private final Partition<V> weaklyConnected;
        private final Map<V, Weighted<DirectedEdge<V>>> incomingEdgeByScc;
        private final Deque<ExclusiveEdge<V>> edgesAndWhatTheyExclude;
        final EdgeQueueMap<V> unseenIncomingEdges;
        private double score;

        private PartialSolution(Partition<V> stronglyConnected, Partition<V> weaklyConnected, Map<V, Weighted<DirectedEdge<V>>> incomingEdgeByScc, Deque<ExclusiveEdge<V>> edgesAndWhatTheyExclude, EdgeQueueMap<V> unseenIncomingEdges, double score) {
            this.stronglyConnected = stronglyConnected;
            this.weaklyConnected = weaklyConnected;
            this.incomingEdgeByScc = incomingEdgeByScc;
            this.edgesAndWhatTheyExclude = edgesAndWhatTheyExclude;
            this.unseenIncomingEdges = unseenIncomingEdges;
            this.score = score;
        }

        public static <T> PartialSolution<T> initialize(WeightedGraph<T> graph) {
            Partition<T> stronglyConnected = Partition.singletons(graph.getNodes());
            HashMap incomingByScc = new HashMap();
            ArrayDeque exclusiveEdges = new ArrayDeque();
            EdgeQueueMap<T> incomingEdges = new EdgeQueueMap<T>(stronglyConnected);
            for (T destinationNode : graph.getNodes()) {
                for (Weighted weighted : graph.getIncomingEdges(destinationNode)) {
                    if (weighted.weight == Double.NEGATIVE_INFINITY) continue;
                    incomingEdges.addEdge(weighted);
                }
            }
            return new PartialSolution<T>(stronglyConnected, Partition.singletons(graph.getNodes()), incomingByScc, exclusiveEdges, incomingEdges, 0.0);
        }

        public Set<V> getNodes() {
            return this.stronglyConnected.getNodes();
        }

        private V merge(Weighted<DirectedEdge<V>> newEdge, EdgeQueueMap<V> unseenIncomingEdges) {
            List<Weighted<DirectedEdge<V>>> cycle = this.getCycle(newEdge);
            ArrayList queuesToMerge = new ArrayList(cycle.size());
            for (Weighted<DirectedEdge<V>> currentEdge : cycle) {
                V destination = this.stronglyConnected.componentOf(((DirectedEdge)currentEdge.val).destination);
                EdgeQueueMap.EdgeQueue queue = unseenIncomingEdges.queueByDestination.get(destination);
                queuesToMerge.add(EdgeQueueMap.QueueAndReplace.of(queue, currentEdge));
                unseenIncomingEdges.queueByDestination.remove(destination);
            }
            for (Weighted<DirectedEdge<V>> e : cycle) {
                this.stronglyConnected.merge(((DirectedEdge)e.val).source, ((DirectedEdge)e.val).destination);
            }
            V component = this.stronglyConnected.componentOf(((DirectedEdge)newEdge.val).destination);
            unseenIncomingEdges.merge(component, queuesToMerge);
            this.incomingEdgeByScc.remove(component);
            return component;
        }

        private List<Weighted<DirectedEdge<V>>> getCycle(Weighted<DirectedEdge<V>> newEdge) {
            ArrayList<Weighted<DirectedEdge<V>>> cycle = new ArrayList<Weighted<DirectedEdge<V>>>();
            Weighted<DirectedEdge<V>> edge = newEdge;
            cycle.add(edge);
            while (!this.stronglyConnected.sameComponent(((DirectedEdge)edge.val).source, ((DirectedEdge)newEdge.val).destination)) {
                edge = this.incomingEdgeByScc.get(this.stronglyConnected.componentOf(((DirectedEdge)edge.val).source));
                cycle.add(edge);
            }
            return cycle;
        }

        public Optional<V> addEdge(ExclusiveEdge<V> wEdgeAndExcludes) {
            DirectedEdge edge = wEdgeAndExcludes.edge;
            double weight = wEdgeAndExcludes.weight;
            Weighted wEdge = Weighted.weighted(edge, weight);
            this.score += weight;
            V destinationScc = this.stronglyConnected.componentOf(edge.destination);
            this.edgesAndWhatTheyExclude.addFirst(wEdgeAndExcludes);
            this.incomingEdgeByScc.put(destinationScc, wEdge);
            if (!this.weaklyConnected.sameComponent(edge.source, edge.destination)) {
                this.weaklyConnected.merge(edge.source, edge.destination);
                return Optional.empty();
            }
            return Optional.of(this.merge(wEdge, this.unseenIncomingEdges));
        }

        private Weighted<Arborescence<V>> recoverBestArborescence() {
            ImmutableMap.Builder parents = ImmutableMap.builder();
            HashSet excluded = new HashSet();
            while (!this.edgesAndWhatTheyExclude.isEmpty()) {
                ExclusiveEdge<V> edgeAndWhatItExcludes = this.edgesAndWhatTheyExclude.pollFirst();
                DirectedEdge edge = edgeAndWhatItExcludes.edge;
                if (excluded.contains(edge)) continue;
                excluded.addAll(edgeAndWhatItExcludes.excluded);
                parents.put(edge.destination, edge.source);
            }
            return Weighted.weighted(Arborescence.of(parents.build()), this.score);
        }

        public Optional<ExclusiveEdge<V>> popBestEdge(V component) {
            return this.popBestEdge(component, Arborescence.empty());
        }

        public Optional<ExclusiveEdge<V>> popBestEdge(V component, Arborescence<V> best) {
            return this.unseenIncomingEdges.popBestEdge(component, best);
        }
    }
}

