/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin.spanningtree;

import ai.grakn.graql.internal.gremlin.spanningtree.Arborescence;
import ai.grakn.graql.internal.gremlin.spanningtree.AutoValue_EdgeQueueMap_QueueAndReplace;
import ai.grakn.graql.internal.gremlin.spanningtree.ExclusiveEdge;
import ai.grakn.graql.internal.gremlin.spanningtree.datastructure.FibonacciQueue;
import ai.grakn.graql.internal.gremlin.spanningtree.graph.DirectedEdge;
import ai.grakn.graql.internal.gremlin.spanningtree.util.Weighted;
import ai.grakn.graql.internal.util.Partition;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

class EdgeQueueMap<V> {
    final Partition<V> partition;
    public final Map<V, EdgeQueue<V>> queueByDestination;

    EdgeQueueMap(Partition<V> partition) {
        this.partition = partition;
        this.queueByDestination = Maps.newHashMap();
    }

    public void addEdge(Weighted<DirectedEdge<V>> edge) {
        V destination = this.partition.componentOf(((DirectedEdge)edge.val).destination);
        if (!this.queueByDestination.containsKey(destination)) {
            this.queueByDestination.put((EdgeQueue<V>)destination, (EdgeQueue<EdgeQueue<V>>)EdgeQueue.create(destination, this.partition));
        }
        LinkedList replaces = Lists.newLinkedList();
        this.queueByDestination.get(destination).addEdge(ExclusiveEdge.of((DirectedEdge)edge.val, replaces, edge.weight));
    }

    public Optional<ExclusiveEdge<V>> popBestEdge(V component, Arborescence<V> best) {
        if (!this.queueByDestination.containsKey(component)) {
            return Optional.empty();
        }
        return this.queueByDestination.get(component).popBestEdge(best);
    }

    public EdgeQueue merge(V component, Iterable<QueueAndReplace<V>> queuesToMerge) {
        EdgeQueue result = EdgeQueue.create(component, this.partition);
        for (QueueAndReplace<V> queueAndReplace : queuesToMerge) {
            EdgeQueue<V> queue = queueAndReplace.queue();
            Weighted<DirectedEdge<V>> replace = queueAndReplace.replace();
            for (ExclusiveEdge wEdgeAndExcluded : queue.edges) {
                List replaces = wEdgeAndExcluded.excluded;
                replaces.add(replace.val);
                result.addEdge(ExclusiveEdge.of(wEdgeAndExcluded.edge, replaces, wEdgeAndExcluded.weight - replace.weight));
            }
        }
        this.queueByDestination.put(component, result);
        return result;
    }

    static abstract class QueueAndReplace<V> {
        QueueAndReplace() {
        }

        abstract EdgeQueue<V> queue();

        abstract Weighted<DirectedEdge<V>> replace();

        static <V> QueueAndReplace<V> of(EdgeQueue<V> queue, Weighted<DirectedEdge<V>> replace) {
            return new AutoValue_EdgeQueueMap_QueueAndReplace<V>(queue, replace);
        }
    }

    public static class EdgeQueue<V> {
        private final V component;
        public final FibonacciQueue<ExclusiveEdge<V>> edges;
        private final Partition<V> partition;

        private EdgeQueue(V component, Partition<V> partition) {
            this.component = component;
            this.edges = FibonacciQueue.create(Collections.reverseOrder());
            this.partition = partition;
        }

        public static <T> EdgeQueue<T> create(T component, Partition<T> partition) {
            return new EdgeQueue<T>(component, partition);
        }

        public void addEdge(ExclusiveEdge<V> exclusiveEdge) {
            if (this.partition.componentOf(exclusiveEdge.edge.source).equals(this.component)) {
                return;
            }
            this.edges.add(exclusiveEdge);
        }

        public Optional<ExclusiveEdge<V>> popBestEdge(Arborescence<V> bestArborescence) {
            if (this.edges.isEmpty()) {
                return Optional.empty();
            }
            LinkedList candidates = Lists.newLinkedList();
            do {
                candidates.addFirst(this.edges.poll());
            } while (!this.edges.isEmpty() && this.edges.comparator().compare((ExclusiveEdge<V>)candidates.getFirst(), this.edges.peek()) == 0 && !bestArborescence.contains(((ExclusiveEdge)candidates.getFirst()).edge));
            ExclusiveEdge bestEdge = (ExclusiveEdge)candidates.removeFirst();
            this.edges.addAll(candidates);
            return Optional.of(bestEdge);
        }
    }
}

