/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin.spanningtree.graph;

import ai.grakn.graql.internal.gremlin.spanningtree.graph.DirectedEdge;
import ai.grakn.graql.internal.gremlin.spanningtree.graph.WeightedGraph;
import ai.grakn.graql.internal.gremlin.spanningtree.util.Weighted;
import com.google.common.base.Preconditions;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DenseWeightedGraph<V>
extends WeightedGraph<V> {
    private final ArrayList<V> nodes;
    private final Map<V, Integer> indexOf;
    private final double[][] weights;

    private DenseWeightedGraph(ArrayList<V> nodes, Map<V, Integer> indexOf, double[][] weights) {
        this.nodes = nodes;
        this.indexOf = indexOf;
        this.weights = weights;
    }

    public static <V> DenseWeightedGraph<V> from(Iterable<V> nodes, double[][] weights) {
        ArrayList nodeList = Lists.newArrayList(nodes);
        Preconditions.checkArgument((nodeList.size() == weights.length ? 1 : 0) != 0);
        HashMap indexOf = Maps.newHashMap();
        for (int i = 0; i < nodeList.size(); ++i) {
            indexOf.put(nodeList.get(i), i);
        }
        return new DenseWeightedGraph<V>(nodeList, indexOf, weights);
    }

    public static DenseWeightedGraph<Integer> from(double[][] weights) {
        ContiguousSet nodes = ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(weights.length)), (DiscreteDomain)DiscreteDomain.integers());
        return DenseWeightedGraph.from(nodes, weights);
    }

    @Override
    public Collection<V> getNodes() {
        return this.nodes;
    }

    @Override
    public double getWeightOf(V source, V dest) {
        if (!this.indexOf.containsKey(source) || !this.indexOf.containsKey(dest)) {
            return Double.NEGATIVE_INFINITY;
        }
        return this.weights[this.indexOf.get(source)][this.indexOf.get(dest)];
    }

    @Override
    public Collection<Weighted<DirectedEdge<V>>> getIncomingEdges(V destinationNode) {
        if (!this.indexOf.containsKey(destinationNode)) {
            return Collections.emptySet();
        }
        int dest = this.indexOf.get(destinationNode);
        ArrayList results = Lists.newArrayList();
        for (int src = 0; src < this.nodes.size(); ++src) {
            results.add(Weighted.weighted(DirectedEdge.from(this.nodes.get(src)).to(destinationNode), this.weights[src][dest]));
        }
        return results;
    }
}

