/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin.spanningtree.graph;

import ai.grakn.graql.internal.gremlin.spanningtree.graph.DirectedEdge;
import ai.grakn.graql.internal.gremlin.spanningtree.graph.WeightedGraph;
import ai.grakn.graql.internal.gremlin.spanningtree.util.Weighted;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SparseWeightedGraph<V>
extends WeightedGraph<V> {
    private final Set<V> nodes;
    private final Map<V, Map<V, Weighted<DirectedEdge<V>>>> incomingEdges;

    private SparseWeightedGraph(Set<V> nodes, Map<V, Map<V, Weighted<DirectedEdge<V>>>> incomingEdges) {
        this.nodes = nodes;
        this.incomingEdges = incomingEdges;
    }

    public static <T> SparseWeightedGraph<T> from(Iterable<T> nodes, Iterable<Weighted<DirectedEdge<T>>> edges) {
        HashMap incomingEdges = Maps.newHashMap();
        for (Weighted<DirectedEdge<T>> edge : edges) {
            if (!incomingEdges.containsKey(((DirectedEdge)edge.val).destination)) {
                incomingEdges.put(((DirectedEdge)edge.val).destination, Maps.newHashMap());
            }
            ((Map)incomingEdges.get(((DirectedEdge)edge.val).destination)).put(((DirectedEdge)edge.val).source, edge);
        }
        return new SparseWeightedGraph(ImmutableSet.copyOf(nodes), incomingEdges);
    }

    public static <T> SparseWeightedGraph<T> from(Iterable<Weighted<DirectedEdge<T>>> edges) {
        HashSet nodes = Sets.newHashSet();
        for (Weighted<DirectedEdge<T>> edge : edges) {
            nodes.add(((DirectedEdge)edge.val).source);
            nodes.add(((DirectedEdge)edge.val).destination);
        }
        return SparseWeightedGraph.from(nodes, edges);
    }

    @Override
    public Collection<V> getNodes() {
        return this.nodes;
    }

    @Override
    public double getWeightOf(V source, V dest) {
        if (!this.incomingEdges.containsKey(dest)) {
            return Double.NEGATIVE_INFINITY;
        }
        Map<V, Weighted<DirectedEdge<V>>> inEdges = this.incomingEdges.get(dest);
        if (!inEdges.containsKey(source)) {
            return Double.NEGATIVE_INFINITY;
        }
        return inEdges.get(source).weight;
    }

    @Override
    public Collection<Weighted<DirectedEdge<V>>> getIncomingEdges(V destinationNode) {
        if (!this.incomingEdges.containsKey(destinationNode)) {
            return ImmutableSet.of();
        }
        return this.incomingEdges.get(destinationNode).values();
    }
}

