/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin.spanningtree.graph;

import ai.grakn.graql.internal.gremlin.spanningtree.graph.DirectedEdge;
import ai.grakn.graql.internal.gremlin.spanningtree.graph.SparseWeightedGraph;
import ai.grakn.graql.internal.gremlin.spanningtree.util.Weighted;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;

public abstract class WeightedGraph<V> {
    public abstract Collection<V> getNodes();

    public abstract double getWeightOf(V var1, V var2);

    public abstract Collection<Weighted<DirectedEdge<V>>> getIncomingEdges(V var1);

    public WeightedGraph<V> filterEdges(Predicate<DirectedEdge<V>> predicate) {
        ArrayList allEdges = Lists.newArrayList();
        for (V node : this.getNodes()) {
            Collection<Weighted<DirectedEdge<V>>> incomingEdges = this.getIncomingEdges(node);
            for (Weighted<DirectedEdge<V>> edge : incomingEdges) {
                if (!predicate.apply(edge.val)) continue;
                allEdges.add(edge);
            }
        }
        return SparseWeightedGraph.from(this.getNodes(), allEdges);
    }
}

