/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.gremlin.spanningtree.util;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;

public class Weighted<T>
implements Comparable<Weighted<T>> {
    public final T val;
    public final double weight;

    public Weighted(T val, double weight) {
        Preconditions.checkNotNull(val);
        Preconditions.checkNotNull((Object)weight);
        this.val = val;
        this.weight = weight;
    }

    public static <T> Weighted<T> weighted(T value, double weight) {
        return new Weighted<T>(value, weight);
    }

    @Override
    public int compareTo(Weighted<T> other) {
        return ComparisonChain.start().compare(other.weight, this.weight).compare(Objects.hashCode((Object[])new Object[]{other.val}), Objects.hashCode((Object[])new Object[]{this.val})).result();
    }

    public boolean equals(Object other) {
        if (!(other instanceof Weighted)) {
            return false;
        }
        Weighted wOther = (Weighted)other;
        return Objects.equal(this.val, wOther.val) && Objects.equal((Object)this.weight, (Object)wOther.weight);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.val, this.weight});
    }

    public String toString() {
        return "Weighted{val=" + this.val + ", weight=" + this.weight + '}';
    }
}

