/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.parser;

import ai.grakn.graql.internal.parser.SyntaxError;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;

public class GraqlErrorListener
extends BaseErrorListener {
    @Nullable
    private final List<String> query;
    private final List<SyntaxError> errors = new ArrayList<SyntaxError>();

    private GraqlErrorListener(@Nullable List<String> query) {
        this.query = query;
    }

    public static GraqlErrorListener withoutQueryString() {
        return new GraqlErrorListener(null);
    }

    public static GraqlErrorListener of(String query) {
        ArrayList queryList = Lists.newArrayList((Object[])query.split("\n"));
        return new GraqlErrorListener(queryList);
    }

    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        if (this.query == null) {
            this.errors.add(SyntaxError.of(line, msg));
        } else {
            this.errors.add(SyntaxError.of(line, msg, this.query.get(line - 1), charPositionInLine));
        }
    }

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public String toString() {
        return this.errors.stream().map(SyntaxError::toString).collect(Collectors.joining("\n"));
    }
}

