/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.parser;

import ai.grakn.graql.internal.antlr.GremlinBaseVisitor;
import ai.grakn.graql.internal.antlr.GremlinLexer;
import ai.grakn.graql.internal.antlr.GremlinParser;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;

public class GremlinVisitor
extends GremlinBaseVisitor<Consumer<PrettyStringBuilder>> {
    private static final Consumer<PrettyStringBuilder> COMMA = s -> s.append(", ");
    private static final Consumer<PrettyStringBuilder> COMMA_AND_NEWLINE = COMMA.andThen(PrettyStringBuilder::newline);

    public static void main(String[] args) throws IOException {
        System.out.println(GremlinVisitor.prettify((CharStream)new ANTLRInputStream(System.in)));
    }

    public static String prettify(GraphTraversal<?, ?> traversal) {
        return GremlinVisitor.prettify((CharStream)new ANTLRInputStream(traversal.toString()));
    }

    private static String prettify(CharStream input) {
        GremlinLexer lexer = new GremlinLexer(input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        GremlinParser parser = new GremlinParser((TokenStream)tokens);
        GremlinVisitor visitor = new GremlinVisitor();
        PrettyStringBuilder pretty = PrettyStringBuilder.create();
        ((Consumer)visitor.visit((ParseTree)parser.traversal())).accept(pretty);
        return pretty.build();
    }

    @Override
    public Consumer<PrettyStringBuilder> visitTraversal(GremlinParser.TraversalContext ctx) {
        return (Consumer)this.visit((ParseTree)ctx.expr());
    }

    @Override
    public Consumer<PrettyStringBuilder> visitList(GremlinParser.ListContext ctx) {
        boolean indent = ctx.expr().size() > 1;
        return str -> {
            str.append("[");
            if (indent) {
                str.indent();
            }
            this.visitWithSeparator((PrettyStringBuilder)str, (List<? extends ParseTree>)ctx.expr(), COMMA_AND_NEWLINE);
            if (indent) {
                str.unindent();
            }
            str.append("]");
        };
    }

    @Override
    public Consumer<PrettyStringBuilder> visitStep(GremlinParser.StepContext ctx) {
        return str -> {
            ((Consumer)this.visit((ParseTree)ctx.call())).accept(str);
            if (ctx.ids() != null) {
                str.append("@");
                ((Consumer)this.visit((ParseTree)ctx.ids())).accept(str);
            }
        };
    }

    @Override
    public Consumer<PrettyStringBuilder> visitCall(GremlinParser.CallContext ctx) {
        return str -> {
            str.append(ctx.ID().toString()).append("(");
            this.visitWithSeparator((PrettyStringBuilder)str, (List<? extends ParseTree>)ctx.expr(), COMMA);
            str.append(")");
        };
    }

    @Override
    public Consumer<PrettyStringBuilder> visitIdExpr(GremlinParser.IdExprContext ctx) {
        return str -> str.append(ctx.ID().toString());
    }

    @Override
    public Consumer<PrettyStringBuilder> visitMethodExpr(GremlinParser.MethodExprContext ctx) {
        return str -> {
            str.append(ctx.ID().toString()).append(".");
            ((Consumer)this.visit((ParseTree)ctx.call())).accept(str);
        };
    }

    @Override
    public Consumer<PrettyStringBuilder> visitListExpr(GremlinParser.ListExprContext ctx) {
        return (Consumer)this.visit((ParseTree)ctx.list());
    }

    @Override
    public Consumer<PrettyStringBuilder> visitStepExpr(GremlinParser.StepExprContext ctx) {
        return (Consumer)this.visit((ParseTree)ctx.step());
    }

    @Override
    public Consumer<PrettyStringBuilder> visitNegExpr(GremlinParser.NegExprContext ctx) {
        return str -> {
            str.append("!");
            ((Consumer)this.visit((ParseTree)ctx.expr())).accept(str);
        };
    }

    @Override
    public Consumer<PrettyStringBuilder> visitSquigglyExpr(GremlinParser.SquigglyExprContext ctx) {
        return str -> {
            str.append("~");
            ((Consumer)this.visit((ParseTree)ctx.expr())).accept(str);
        };
    }

    @Override
    public Consumer<PrettyStringBuilder> visitMapExpr(GremlinParser.MapExprContext ctx) {
        return str -> {
            str.append("{").indent();
            this.visitWithSeparator((PrettyStringBuilder)str, (List<? extends ParseTree>)ctx.mapEntry(), COMMA_AND_NEWLINE);
            str.unindent().append("}");
        };
    }

    @Override
    public Consumer<PrettyStringBuilder> visitMapEntry(GremlinParser.MapEntryContext ctx) {
        return str -> {
            str.append(ctx.ID().toString()).append("=");
            ((Consumer)this.visit((ParseTree)ctx.expr())).accept(str);
        };
    }

    @Override
    public Consumer<PrettyStringBuilder> visitIds(GremlinParser.IdsContext ctx) {
        return str -> {
            str.append("[");
            this.visitWithSeparator((PrettyStringBuilder)str, (List<? extends ParseTree>)ctx.ID(), COMMA);
            str.append("]");
        };
    }

    public Consumer<PrettyStringBuilder> visitTerminal(TerminalNode node) {
        return str -> str.append(node.getText());
    }

    private void visitWithSeparator(PrettyStringBuilder str, List<? extends ParseTree> trees, Consumer<PrettyStringBuilder> elem) {
        Stream<Consumer> exprs = trees.stream().map(arg_0 -> ((GremlinVisitor)this).visit(arg_0));
        this.intersperse(exprs, elem).forEach(consumer -> consumer.accept(str));
    }

    private <T> Stream<T> intersperse(Stream<T> stream, T elem) {
        return stream.flatMap(i -> Stream.of(elem, i)).skip(1L);
    }

    static class PrettyStringBuilder {
        private final StringBuilder builder = new StringBuilder();
        private int indent = 0;
        private boolean newline = false;
        private static final String INDENT_STR = "    ";

        PrettyStringBuilder() {
        }

        static PrettyStringBuilder create() {
            return new PrettyStringBuilder();
        }

        PrettyStringBuilder append(String string) {
            if (this.newline) {
                this.builder.append("\n");
                this.builder.append(Strings.repeat((String)INDENT_STR, (int)this.indent));
                this.newline = false;
            }
            this.builder.append(string);
            return this;
        }

        PrettyStringBuilder indent() {
            this.newline();
            ++this.indent;
            return this;
        }

        PrettyStringBuilder unindent() {
            this.newline();
            --this.indent;
            return this;
        }

        PrettyStringBuilder newline() {
            this.newline = true;
            return this;
        }

        String build() {
            return this.builder.toString();
        }
    }
}

