/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.parser;

import ai.grakn.concept.AttributeType;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.exception.GraqlSyntaxException;
import ai.grakn.graql.Aggregate;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.Query;
import ai.grakn.graql.QueryBuilder;
import ai.grakn.graql.QueryParser;
import ai.grakn.graql.Var;
import ai.grakn.graql.internal.antlr.GraqlLexer;
import ai.grakn.graql.internal.antlr.GraqlParser;
import ai.grakn.graql.internal.parser.ChannelTokenSource;
import ai.grakn.graql.internal.parser.GraqlErrorListener;
import ai.grakn.graql.internal.parser.QueryVisitor;
import ai.grakn.graql.internal.query.aggregate.Aggregates;
import ai.grakn.graql.internal.template.TemplateParser;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BailErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenFactory;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenFactory;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.UnbufferedCharStream;
import org.antlr.v4.runtime.UnbufferedTokenStream;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;

public class QueryParserImpl
implements QueryParser {
    private final QueryBuilder queryBuilder;
    private final TemplateParser templateParser = TemplateParser.create();
    private final Map<String, Function<List<Object>, Aggregate>> aggregateMethods = new HashMap<String, Function<List<Object>, Aggregate>>();
    private boolean defineAllVars = false;
    public static final ImmutableBiMap<String, AttributeType.DataType> DATA_TYPES = ImmutableBiMap.of((Object)"long", (Object)AttributeType.DataType.LONG, (Object)"double", (Object)AttributeType.DataType.DOUBLE, (Object)"string", (Object)AttributeType.DataType.STRING, (Object)"boolean", (Object)AttributeType.DataType.BOOLEAN, (Object)"date", (Object)AttributeType.DataType.DATE);
    private final QueryPart<GraqlParser.QueryListContext, Stream<? extends Query<?>>> QUERY_LIST = this.createQueryPart(GraqlParser::queryList, QueryVisitor::visitQueryList);
    private final QueryPart<GraqlParser.QueryEOFContext, Query<?>> QUERY_EOF = this.createQueryPart(GraqlParser::queryEOF, QueryVisitor::visitQueryEOF);
    private final QueryPart<GraqlParser.QueryContext, Query<?>> QUERY = this.createQueryPart(GraqlParser::query, QueryVisitor::visitQuery);
    private final QueryPart<GraqlParser.PatternsContext, List<Pattern>> PATTERNS = this.createQueryPart(GraqlParser::patterns, QueryVisitor::visitPatterns);
    private final QueryPart<GraqlParser.PatternContext, Pattern> PATTERN = this.createQueryPart(GraqlParser::pattern, QueryVisitor::visitPattern);

    private QueryParserImpl(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    public static QueryParser create(QueryBuilder queryBuilder) {
        QueryParserImpl parser = new QueryParserImpl(queryBuilder);
        parser.registerDefaultAggregates();
        return parser;
    }

    private void registerAggregate(String name, int numArgs, Function<List<Object>, Aggregate> aggregateMethod) {
        this.registerAggregate(name, numArgs, numArgs, aggregateMethod);
    }

    private void registerAggregate(String name, int minArgs, int maxArgs, Function<List<Object>, Aggregate> aggregateMethod) {
        this.aggregateMethods.put(name, args -> {
            if (args.size() < minArgs || args.size() > maxArgs) {
                throw GraqlQueryException.incorrectAggregateArgumentNumber((String)name, (int)minArgs, (int)maxArgs, (List)args);
            }
            return (Aggregate)aggregateMethod.apply((List<Object>)args);
        });
    }

    public void registerAggregate(String name, Function<List<Object>, Aggregate> aggregateMethod) {
        this.aggregateMethods.put(name, aggregateMethod);
    }

    public void defineAllVars(boolean defineAllVars) {
        this.defineAllVars = defineAllVars;
    }

    public <T extends Query<?>> T parseQuery(String queryString) {
        return (T)this.QUERY_EOF.parse(queryString);
    }

    public <T extends Query<?>> Stream<T> parseList(Reader reader) {
        UnbufferedCharStream charStream = new UnbufferedCharStream(reader);
        final GraqlErrorListener errorListener = GraqlErrorListener.withoutQueryString();
        GraqlLexer lexer = QueryParserImpl.createLexer((CharStream)charStream, errorListener);
        lexer.setTokenFactory((TokenFactory)new CommonTokenFactory(true));
        final UnbufferedTokenStream tokenStream = new UnbufferedTokenStream((TokenSource)ChannelTokenSource.of((TokenSource)lexer));
        final GraqlParser parser = QueryParserImpl.createParser((TokenStream)tokenStream, errorListener);
        parser.setErrorHandler((ANTLRErrorStrategy)new BailErrorStrategy());
        Iterable queryIterator = () -> new AbstractIterator<T>(){

            @Nullable
            protected T computeNext() {
                int latestToken = tokenStream.LA(1);
                if (latestToken == -1) {
                    this.endOfData();
                    return null;
                }
                return (Query)QueryParserImpl.this.QUERY.parse(parser, errorListener);
            }
        };
        return StreamSupport.stream(queryIterator.spliterator(), false);
    }

    public <T extends Query<?>> Stream<T> parseList(String queryString) {
        return this.QUERY_LIST.parse(queryString);
    }

    public List<Pattern> parsePatterns(String patternsString) {
        return this.PATTERNS.parse(patternsString);
    }

    public Pattern parsePattern(String patternString) {
        return this.PATTERN.parse(patternString);
    }

    public <T extends Query<?>> Stream<T> parseTemplate(String template, Map<String, Object> data) {
        return this.parseList(this.templateParser.parseTemplate(template, data));
    }

    private static GraqlLexer createLexer(CharStream input, GraqlErrorListener errorListener) {
        GraqlLexer lexer = new GraqlLexer(input);
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)errorListener);
        return lexer;
    }

    private static GraqlParser createParser(TokenStream tokens, GraqlErrorListener errorListener) {
        GraqlParser parser = new GraqlParser(tokens);
        parser.removeErrorListeners();
        parser.addErrorListener((ANTLRErrorListener)errorListener);
        return parser;
    }

    private QueryVisitor getQueryVisitor() {
        ImmutableMap immutableAggregates = ImmutableMap.copyOf(this.aggregateMethods);
        return new QueryVisitor((ImmutableMap<String, Function<List<Object>, Aggregate>>)immutableAggregates, this.queryBuilder, this.defineAllVars);
    }

    private void registerDefaultAggregates() {
        this.registerAggregate("count", 0, args -> Graql.count());
        this.registerAggregate("ask", 0, args -> Graql.ask());
        this.registerAggregate("sum", 1, args -> Aggregates.sum((Var)args.get(0)));
        this.registerAggregate("max", 1, args -> Aggregates.max((Var)args.get(0)));
        this.registerAggregate("min", 1, args -> Aggregates.min((Var)args.get(0)));
        this.registerAggregate("mean", 1, args -> Aggregates.mean((Var)args.get(0)));
        this.registerAggregate("median", 1, args -> Aggregates.median((Var)args.get(0)));
        this.registerAggregate("std", 1, args -> Aggregates.std((Var)args.get(0)));
        this.registerAggregate("group", 1, 2, args -> {
            if (args.size() < 2) {
                return Aggregates.group((Var)args.get(0));
            }
            return Aggregates.group((Var)args.get(0), (Aggregate)args.get(1));
        });
    }

    private <S extends ParseTree, T> QueryPart<S, T> createQueryPart(final Function<GraqlParser, S> parseTree, final BiFunction<QueryVisitor, S, T> visit) {
        return new QueryPart<S, T>(){

            @Override
            S parseTree(GraqlParser parser) {
                return (ParseTree)parseTree.apply(parser);
            }

            @Override
            T visit(QueryVisitor visitor, S context) {
                return visit.apply(visitor, context);
            }
        };
    }

    private abstract class QueryPart<S extends ParseTree, T> {
        private QueryPart() {
        }

        abstract S parseTree(GraqlParser var1) throws ParseCancellationException;

        abstract T visit(QueryVisitor var1, S var2);

        final T parse(String queryString) {
            ANTLRInputStream charStream = new ANTLRInputStream(queryString);
            GraqlErrorListener errorListener = GraqlErrorListener.of(queryString);
            GraqlLexer lexer = QueryParserImpl.createLexer((CharStream)charStream, errorListener);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            GraqlParser parser = QueryParserImpl.createParser((TokenStream)tokens, errorListener);
            return this.parse(parser, errorListener);
        }

        final T parse(GraqlParser parser, GraqlErrorListener errorListener) {
            S tree;
            try {
                tree = this.parseTree(parser);
            }
            catch (ParseCancellationException e) {
                throw GraqlSyntaxException.parsingError((String)"syntax error");
            }
            if (errorListener.hasErrors()) {
                throw GraqlSyntaxException.parsingError((String)errorListener.toString());
            }
            return this.visit(QueryParserImpl.this.getQueryVisitor(), tree);
        }
    }
}

