/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.parser;

import ai.grakn.graql.internal.parser.AutoValue_SyntaxError;
import ai.grakn.util.ErrorMessage;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

abstract class SyntaxError {
    SyntaxError() {
    }

    @Nullable
    abstract String queryLine();

    abstract int line();

    abstract int charPositionInLine();

    abstract String msg();

    static SyntaxError of(int line, String msg) {
        return SyntaxError.of(line, msg, null, 0);
    }

    static SyntaxError of(int line, String msg, @Nullable String queryLine, int charPositionInLine) {
        return new AutoValue_SyntaxError(queryLine, line, charPositionInLine, msg);
    }

    public String toString() {
        if (this.queryLine() == null) {
            return ErrorMessage.SYNTAX_ERROR_NO_POINTER.getMessage(new Object[]{this.line(), this.msg()});
        }
        String pointer = StringUtils.repeat((String)" ", (int)this.charPositionInLine()) + "^";
        return ErrorMessage.SYNTAX_ERROR.getMessage(new Object[]{this.line(), this.queryLine(), pointer, this.msg()});
    }
}

