/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.pattern;

import ai.grakn.concept.AttributeType;
import ai.grakn.concept.ConceptId;
import ai.grakn.concept.Label;
import ai.grakn.exception.GraqlQueryException;
import ai.grakn.graql.Graql;
import ai.grakn.graql.Pattern;
import ai.grakn.graql.ValuePredicate;
import ai.grakn.graql.Var;
import ai.grakn.graql.VarPattern;
import ai.grakn.graql.admin.Conjunction;
import ai.grakn.graql.admin.Disjunction;
import ai.grakn.graql.admin.RelationPlayer;
import ai.grakn.graql.admin.UniqueVarProperty;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.admin.VarProperty;
import ai.grakn.graql.internal.pattern.AbstractPattern;
import ai.grakn.graql.internal.pattern.Patterns;
import ai.grakn.graql.internal.pattern.property.DataTypeProperty;
import ai.grakn.graql.internal.pattern.property.HasAttributeProperty;
import ai.grakn.graql.internal.pattern.property.HasAttributeTypeProperty;
import ai.grakn.graql.internal.pattern.property.IdProperty;
import ai.grakn.graql.internal.pattern.property.IsAbstractProperty;
import ai.grakn.graql.internal.pattern.property.IsaProperty;
import ai.grakn.graql.internal.pattern.property.LabelProperty;
import ai.grakn.graql.internal.pattern.property.NeqProperty;
import ai.grakn.graql.internal.pattern.property.PlaysProperty;
import ai.grakn.graql.internal.pattern.property.RegexProperty;
import ai.grakn.graql.internal.pattern.property.RelatesProperty;
import ai.grakn.graql.internal.pattern.property.RelationshipProperty;
import ai.grakn.graql.internal.pattern.property.SubProperty;
import ai.grakn.graql.internal.pattern.property.ThenProperty;
import ai.grakn.graql.internal.pattern.property.ValueProperty;
import ai.grakn.graql.internal.pattern.property.WhenProperty;
import ai.grakn.graql.internal.util.StringConverter;
import ai.grakn.util.CommonUtil;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractVarPattern
extends AbstractPattern
implements VarPatternAdmin {
    public abstract Var var();

    protected abstract Set<VarProperty> properties();

    public final VarPatternAdmin admin() {
        return this;
    }

    public final Optional<Label> getTypeLabel() {
        return this.getProperty(LabelProperty.class).map(LabelProperty::label);
    }

    public final <T extends VarProperty> Stream<T> getProperties(Class<T> type) {
        return this.getProperties().filter(type::isInstance).map(type::cast);
    }

    public final <T extends UniqueVarProperty> Optional<T> getProperty(Class<T> type) {
        return this.getProperties().filter(type::isInstance).map(type::cast).findAny();
    }

    public final <T extends VarProperty> boolean hasProperty(Class<T> type) {
        return this.getProperties(type).findAny().isPresent();
    }

    public final Collection<VarPatternAdmin> innerVarPatterns() {
        Stack<AbstractVarPattern> newVars = new Stack<AbstractVarPattern>();
        ArrayList<VarPatternAdmin> vars = new ArrayList<VarPatternAdmin>();
        newVars.add(this);
        while (!newVars.isEmpty()) {
            VarPatternAdmin var = (VarPatternAdmin)newVars.pop();
            vars.add(var);
            var.getProperties().flatMap(VarProperty::innerVarPatterns).forEach(newVars::add);
        }
        return vars;
    }

    public final Collection<VarPatternAdmin> implicitInnerVarPatterns() {
        Stack<AbstractVarPattern> newVars = new Stack<AbstractVarPattern>();
        ArrayList<VarPatternAdmin> vars = new ArrayList<VarPatternAdmin>();
        newVars.add(this);
        while (!newVars.isEmpty()) {
            VarPatternAdmin var = (VarPatternAdmin)newVars.pop();
            vars.add(var);
            var.getProperties().flatMap(VarProperty::implicitInnerVarPatterns).forEach(newVars::add);
        }
        return vars;
    }

    public final Set<Label> getTypeLabels() {
        return this.getProperties().flatMap(VarProperty::getTypes).map(VarPatternAdmin::getTypeLabel).flatMap(CommonUtil::optionalToStream).collect(Collectors.toSet());
    }

    public final Disjunction<Conjunction<VarPatternAdmin>> getDisjunctiveNormalForm() {
        Conjunction<AbstractVarPattern> conjunction = Patterns.conjunction(Collections.singleton(this));
        return Patterns.disjunction(Collections.singleton(conjunction));
    }

    public final Set<Var> commonVars() {
        return this.innerVarPatterns().stream().filter(v -> v.var().isUserDefinedName()).map(VarPatternAdmin::var).collect(Collectors.toSet());
    }

    public final VarPattern id(ConceptId id) {
        return this.addProperty(IdProperty.of(id));
    }

    public final VarPattern label(String label) {
        return this.label(Label.of((String)label));
    }

    public final VarPattern label(Label label) {
        return this.addProperty(LabelProperty.of(label));
    }

    public final VarPattern val(Object value) {
        return this.val(Graql.eq(value));
    }

    public final VarPattern val(ValuePredicate predicate) {
        return this.addProperty(ValueProperty.of(predicate));
    }

    public final VarPattern has(String type, Object value) {
        return this.has(type, Graql.eq(value));
    }

    public final VarPattern has(String type, ValuePredicate predicate) {
        return this.has(type, Graql.var().val(predicate));
    }

    public final VarPattern has(String type, VarPattern attribute) {
        return this.has(Label.of((String)type), attribute);
    }

    public final VarPattern has(Label type, VarPattern attribute) {
        return this.has(type, attribute, (VarPattern)Graql.var());
    }

    public final VarPattern has(Label type, VarPattern attribute, VarPattern relationship) {
        return this.addProperty(HasAttributeProperty.of(type, attribute.admin(), relationship.admin()));
    }

    public final VarPattern isa(String type) {
        return this.isa(Graql.label(type));
    }

    public final VarPattern isa(VarPattern type) {
        return this.addProperty(IsaProperty.of(type.admin()));
    }

    public final VarPattern sub(String type) {
        return this.sub(Graql.label(type));
    }

    public final VarPattern sub(VarPattern type) {
        return this.addProperty(SubProperty.of(type.admin()));
    }

    public final VarPattern relates(String type) {
        return this.relates(Graql.label(type));
    }

    public final VarPattern relates(VarPattern type) {
        return this.addProperty(RelatesProperty.of(type.admin()));
    }

    public final VarPattern plays(String type) {
        return this.plays(Graql.label(type));
    }

    public final VarPattern plays(VarPattern type) {
        return this.addProperty(PlaysProperty.of(type.admin(), false));
    }

    public final VarPattern has(String type) {
        return this.has(Graql.label(type));
    }

    public final VarPattern has(VarPattern type) {
        return this.addProperty(HasAttributeTypeProperty.of(type.admin(), false));
    }

    public final VarPattern key(String type) {
        return this.key(Graql.var().label(type));
    }

    public final VarPattern key(VarPattern type) {
        return this.addProperty(HasAttributeTypeProperty.of(type.admin(), true));
    }

    public final VarPattern rel(String roleplayer) {
        return this.rel((VarPattern)Graql.var(roleplayer));
    }

    public final VarPattern rel(VarPattern roleplayer) {
        return this.addCasting(RelationPlayer.of((VarPatternAdmin)roleplayer.admin()));
    }

    public final VarPattern rel(String role, String roleplayer) {
        return this.rel(Graql.label(role), (VarPattern)Graql.var(roleplayer));
    }

    public final VarPattern rel(VarPattern role, String roleplayer) {
        return this.rel(role, (VarPattern)Graql.var(roleplayer));
    }

    public final VarPattern rel(String role, VarPattern roleplayer) {
        return this.rel(Graql.label(role), roleplayer);
    }

    public final VarPattern rel(VarPattern role, VarPattern roleplayer) {
        return this.addCasting(RelationPlayer.of((VarPatternAdmin)role.admin(), (VarPatternAdmin)roleplayer.admin()));
    }

    public final VarPattern isAbstract() {
        return this.addProperty(IsAbstractProperty.get());
    }

    public final VarPattern datatype(AttributeType.DataType<?> datatype) {
        return this.addProperty(DataTypeProperty.of(datatype));
    }

    public final VarPattern regex(String regex) {
        return this.addProperty(RegexProperty.of(regex));
    }

    public final VarPattern when(Pattern when) {
        return this.addProperty(WhenProperty.of(when));
    }

    public final VarPattern then(Pattern then) {
        return this.addProperty(ThenProperty.of(then));
    }

    public final VarPattern neq(String var) {
        return this.neq((VarPattern)Graql.var(var));
    }

    public final VarPattern neq(VarPattern varPattern) {
        return this.addProperty(NeqProperty.of(varPattern.admin()));
    }

    public final String getPrintableName() {
        Optional<Label> label;
        if (this.properties().size() == 0) {
            return this.var().toString();
        }
        if (this.properties().size() == 1 && (label = this.getTypeLabel()).isPresent()) {
            return StringConverter.typeLabelToString(label.get());
        }
        return "`" + this.toString() + "`";
    }

    public final Stream<VarProperty> getProperties() {
        return this.properties().stream();
    }

    private VarPattern addCasting(RelationPlayer relationPlayer) {
        Optional<RelationshipProperty> relationProperty = this.getProperty(RelationshipProperty.class);
        ImmutableMultiset oldCastings = relationProperty.map(RelationshipProperty::relationPlayers).orElse(ImmutableMultiset.of());
        ImmutableMultiset relationPlayers = (ImmutableMultiset)Stream.concat(oldCastings.stream(), Stream.of(relationPlayer)).collect(CommonUtil.toImmutableMultiset());
        RelationshipProperty newProperty = RelationshipProperty.of((ImmutableMultiset<RelationPlayer>)relationPlayers);
        return relationProperty.map(this::removeProperty).orElse(this).addProperty(newProperty);
    }

    private VarPatternAdmin addProperty(VarProperty property) {
        if (property.isUnique()) {
            this.testUniqueProperty((UniqueVarProperty)property);
        }
        return Patterns.varPattern(this.var(), (Set<VarProperty>)Sets.union(this.properties(), (Set)ImmutableSet.of((Object)property)));
    }

    private AbstractVarPattern removeProperty(VarProperty property) {
        return (AbstractVarPattern)Patterns.varPattern(this.var(), (Set<VarProperty>)Sets.difference(this.properties(), (Set)ImmutableSet.of((Object)property)));
    }

    private void testUniqueProperty(UniqueVarProperty property) {
        this.getProperty(property.getClass()).filter(other -> !other.equals(property)).ifPresent(other -> {
            throw GraqlQueryException.conflictingProperties((VarPatternAdmin)this, (UniqueVarProperty)property, (UniqueVarProperty)other);
        });
    }
}

