/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.pattern;

import ai.grakn.GraknTx;
import ai.grakn.graql.Var;
import ai.grakn.graql.admin.Conjunction;
import ai.grakn.graql.admin.Disjunction;
import ai.grakn.graql.admin.PatternAdmin;
import ai.grakn.graql.admin.ReasonerQuery;
import ai.grakn.graql.admin.VarPatternAdmin;
import ai.grakn.graql.internal.pattern.AbstractPattern;
import ai.grakn.graql.internal.pattern.Patterns;
import ai.grakn.graql.internal.reasoner.query.ReasonerQueries;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

abstract class ConjunctionImpl<T extends PatternAdmin>
extends AbstractPattern
implements Conjunction<T> {
    ConjunctionImpl() {
    }

    public abstract Set<T> getPatterns();

    public Disjunction<Conjunction<VarPatternAdmin>> getDisjunctiveNormalForm() {
        List disjunctionsOfConjunctions = this.getPatterns().stream().map(p -> p.getDisjunctiveNormalForm().getPatterns()).collect(Collectors.toList());
        Set dnf = Sets.cartesianProduct(disjunctionsOfConjunctions).stream().map(ConjunctionImpl::fromConjunctions).collect(Collectors.toSet());
        return Patterns.disjunction(dnf);
    }

    public Set<Var> commonVars() {
        return this.getPatterns().stream().map(PatternAdmin::commonVars).reduce((Set)ImmutableSet.of(), Sets::union);
    }

    public boolean isConjunction() {
        return true;
    }

    public Conjunction<?> asConjunction() {
        return this;
    }

    public ReasonerQuery toReasonerQuery(GraknTx tx) {
        Conjunction pattern = (Conjunction)Iterables.getOnlyElement((Iterable)this.getDisjunctiveNormalForm().getPatterns());
        return ReasonerQueries.create((Conjunction<VarPatternAdmin>)pattern, tx);
    }

    private static <U extends PatternAdmin> Conjunction<U> fromConjunctions(List<Conjunction<U>> conjunctions) {
        Set patterns = conjunctions.stream().flatMap(p -> p.getPatterns().stream()).collect(Collectors.toSet());
        return Patterns.conjunction(patterns);
    }

    public String toString() {
        return "{" + this.getPatterns().stream().map(s -> s + ";").collect(Collectors.joining(" ")) + "}";
    }

    public PatternAdmin admin() {
        return this;
    }
}

