/*
 * Decompiled with CFR 0.152.
 */
package ai.grakn.graql.internal.pattern;

import ai.grakn.graql.Var;
import ai.grakn.graql.admin.VarProperty;
import ai.grakn.graql.internal.pattern.AbstractVarPattern;
import ai.grakn.graql.internal.pattern.AutoValue_VarImpl;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

abstract class VarImpl
extends AbstractVarPattern
implements Var {
    private static final Pattern VALID_VAR = Pattern.compile("[a-zA-Z0-9_-]+");

    VarImpl() {
    }

    static VarImpl of(String value, Var.Kind kind) {
        Preconditions.checkArgument((boolean)VALID_VAR.matcher(value).matches(), (String)"Var value [%s] is invalid. Must match regex %s", (Object[])new Object[]{value, VALID_VAR});
        return new AutoValue_VarImpl(value, kind);
    }

    public boolean isUserDefinedName() {
        return this.kind() == Var.Kind.UserDefined;
    }

    public Var asUserDefined() {
        if (this.isUserDefinedName()) {
            return this;
        }
        return VarImpl.of(this.getValue(), Var.Kind.UserDefined);
    }

    public String name() {
        return this.kind().prefix() + this.getValue();
    }

    public String shortName() {
        return this.kind().prefix() + StringUtils.right((String)this.getValue(), (int)3);
    }

    @Override
    public Var var() {
        return this;
    }

    @Override
    protected Set<VarProperty> properties() {
        return ImmutableSet.of();
    }

    public String toString() {
        return "$" + this.getValue();
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VarImpl varName = (VarImpl)o;
        return this.getValue().equals(varName.getValue());
    }

    public final int hashCode() {
        return this.getValue().hashCode();
    }
}

